/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.deploy.web.jnlp;

import org.jdom2.Content;
import org.jdom2.Element;
import org.smyld.deploy.web.Descriptor;
import org.smyld.deploy.web.jnlp.ShortcutDescriptor;
import org.smyld.xml.XMLUtil;

public class InfoDescriptor
extends Descriptor {
    private static final long serialVersionUID = 1L;
    String title;
    String vendor;
    String homePage;
    String description;
    String tooltip;
    String icon;
    ShortcutDescriptor shortCut;
    boolean offlineAllowed;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getHomePage() {
        return this.homePage;
    }

    public void setHomePage(String homePage) {
        this.homePage = homePage;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Element getXMLElement() {
        Element info = new Element("information");
        XMLUtil.addChildElement(info, "title", this.getTitle());
        XMLUtil.addChildElement(info, "vendor", this.getVendor());
        XMLUtil.addChildElement(info, "description", this.getDescription());
        XMLUtil.addChildElement(info, "homepage", this.getHomePage());
        if (this.getTooltip() != null) {
            Element tooltipEl = new Element("description");
            tooltipEl.setAttribute("kind", "tooltip");
            tooltipEl.setText(this.getTooltip());
            info.addContent((Content)tooltipEl);
        }
        if (this.getIcon() != null) {
            Element iconEl = new Element("icon");
            iconEl.setAttribute("href", this.getIcon());
            info.addContent((Content)iconEl);
        }
        if (this.isOfflineAllowed()) {
            XMLUtil.addChildElement(info, "offline-allowed", "");
        }
        if (this.getShortCut() != null) {
            info.addContent((Content)this.getShortCut().getXMLElement());
        }
        return info;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public ShortcutDescriptor getShortCut() {
        return this.shortCut;
    }

    public void setShortCut(ShortcutDescriptor shortCut) {
        this.shortCut = shortCut;
    }

    public boolean isOfflineAllowed() {
        return this.offlineAllowed;
    }

    public void setOfflineAllowed(boolean offlineAllowed) {
        this.offlineAllowed = offlineAllowed;
    }
}

