/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.deploy.web.jnlp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.smyld.deploy.web.SMYLDWARWriter;
import org.smyld.deploy.web.jnlp.JNLPConstants;
import org.smyld.deploy.web.jnlp.JNLPDeploymentDescriptor;
import org.smyld.deploy.web.jnlp.JNLPFileWriter;
import org.smyld.deploy.web.jnlp.JNLPHTMLDocument;
import org.smyld.security.SMYLDKey;
import org.smyld.util.SMYLDJavaTools;
import org.smyld.util.jar.SMYLDJARWriter;

public class SMYLDJNLPWriter
extends SMYLDWARWriter
implements JNLPConstants {
    SMYLDKey signKey;
    String mainJarFile;
    JNLPFileWriter jnlpFile;
    JNLPHTMLDocument htmlDoc;
    boolean generateLaunchPage;

    public SMYLDJNLPWriter(OutputStream out) throws IOException {
        super(out);
        this.init();
    }

    public SMYLDJNLPWriter(String outName) throws IOException {
        super(outName);
        this.init();
    }

    private void init() {
        this.jnlpFile = new JNLPFileWriter();
        this.webSettingsFile.addJNLPMappings();
    }

    public void signJarFile(SMYLDKey signingKey) {
        this.signKey = signingKey;
    }

    public void addMainJarFile(String MainJarFile, SMYLDKey signingKey) {
        this.signKey = signingKey;
        this.addMainJarFile(MainJarFile);
    }

    public void addMainJarFile(String MainJarFile) {
        this.mainJarFile = MainJarFile;
    }

    private void handelSecuritySigniture() throws Exception {
        if (this.mainJarFile != null) {
            File tempFile = new File(this.mainJarFile + ".tmp");
            String jnlpTempFilePath = tempFile.getParent() + File.separator;
            this.jnlpFile.setFileName(this.jnlpFile.getName());
            this.jnlpFile.writeFileToPath(jnlpTempFilePath);
            jnlpTempFilePath = jnlpTempFilePath + this.jnlpFile.getName();
            SMYLDJARWriter writer = new SMYLDJARWriter(new FileOutputStream(tempFile));
            writer.addLibrary(this.mainJarFile);
            writer.addFile(jnlpTempFilePath, "JNLP-INF/APPLICATION.JNLP");
            writer.close();
            this.addFile(jnlpTempFilePath, this.jnlpFile.getName());
            SMYLDJavaTools tools = new SMYLDJavaTools();
            boolean result = tools.signJarFile(tempFile.getPath(), this.signKey);
            if (result) {
                System.out.println("Finished siging the file .... ");
                this.addFile(tempFile.getPath(), "apps/" + new File(this.mainJarFile).getName());
                tempFile.delete();
            }
        }
    }

    private void addJarFileToPackage(String jarFileSource) throws Exception {
        File testJar = new File(jarFileSource);
        if (testJar.exists()) {
            this.addFile(testJar.getPath(), "apps/" + testJar.getName());
        }
    }

    @Override
    public void compose() {
        try {
            if (this.signKey != null) {
                this.handelSecuritySigniture();
            } else {
                this.addJarFileToPackage(this.mainJarFile);
                this.addXMLFile(this.jnlpFile.getRootElement(), this.jnlpFile.getName());
            }
            if (this.isGenerateLaunchPage()) {
                if (this.htmlDoc == null) {
                    this.htmlDoc = new JNLPHTMLDocument(this.jnlpFile);
                }
                this.addXMLFile(this.htmlDoc.getRootElement(), "index.html");
            }
            super.compose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JNLPFileWriter getJNLPFile() {
        return this.jnlpFile;
    }

    public boolean isGenerateLaunchPage() {
        return this.generateLaunchPage;
    }

    public void setGenerateLaunchPage(boolean generateLaunchPage) {
        this.generateLaunchPage = generateLaunchPage;
    }

    public void importDescriptor(JNLPDeploymentDescriptor desc) {
        this.jnlpFile.importDescriptor(desc);
        if (desc.getHtmlDocument() != null) {
            try {
                this.htmlDoc = new JNLPHTMLDocument(this.jnlpFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.htmlDoc.setTitle(desc.getHtmlDocument().getTitle());
            this.htmlDoc.setHeadline(desc.getHtmlDocument().getHeadline());
            this.setGenerateLaunchPage(true);
        }
    }
}

