/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.io;

import java.io.File;
import java.util.HashMap;
import org.smyld.SMYLDObject;
import org.smyld.io.FileListenSource;
import org.smyld.io.FileMonitorListener;

public class FilesMonitor
extends SMYLDObject
implements Runnable {
    private static final long serialVersionUID = 1L;
    long sleepTime;
    boolean monitoringActive;
    FileMonitorListener listener;
    HashMap<String, FileListenSource> registry;
    HashMap<String, String> informedFiles = new HashMap();

    public void setSleepTime(long newSleepTime) {
        this.sleepTime = newSleepTime;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void registerMonitoring(FileListenSource newSource) {
        if (this.registry == null) {
            this.registry = new HashMap();
        }
        this.registry.put(newSource.getKey(), newSource);
    }

    public void addFileMonitorListener(FileMonitorListener fileListener) {
        this.listener = fileListener;
    }

    public void startMonitoring() {
        this.monitoringActive = true;
        Thread newThread = new Thread(this);
        newThread.start();
    }

    public void stopMonitoring() {
        this.monitoringActive = false;
    }

    @Override
    public void run() {
        while (this.monitoringActive) {
            for (FileListenSource currentSource : this.registry.values()) {
                File[] resultantFiles = currentSource.getSourcePath().listFiles(currentSource.getFilter());
                if (resultantFiles == null || resultantFiles.length <= 0) continue;
                this.listener.filesRecieved(currentSource.getSourcePath().getPath(), currentSource.getFilter().getAcceptedFiles());
                this.informedFiles.putAll(currentSource.getFilter().getAcceptedFiles());
                currentSource.getFilter().clearAcceptedFiles();
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

