/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.log;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.smyld.log.AbstractLogManager;
import org.smyld.log.LogManager;
import org.smyld.log.LogRecord;
import org.smyld.log.LogRecordWriter;

public class LifeLogManager
extends AbstractLogManager
implements LogManager {
    private static final long serialVersionUID = 1L;
    FileOutputStream fout;
    LogRecordWriter recordWriter;

    public LifeLogManager(String filePath, LogRecordWriter RecordWriter, boolean append) throws IOException {
        this.fout = new FileOutputStream(filePath, append);
        this.recordWriter = RecordWriter;
        if (this.recordWriter.printFileHeader() != null) {
            this.writeLineToFile(this.recordWriter.printFileHeader());
        }
    }

    public LifeLogManager(String filePath, LogRecordWriter RecordWriter) throws IOException {
        this(filePath, RecordWriter, true);
    }

    @Override
    public synchronized void addRecord(LogRecord record) {
        this.writeLineToFile(this.recordWriter.printRecord(record));
    }

    private synchronized void writeLineToFile(String text) {
        try {
            this.fout.write((text + SYS_NEW_LINE).getBytes());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Collection<LogRecord> getRecords() {
        return null;
    }

    @Override
    public LogRecord fetchRecord(Object ob) {
        return null;
    }

    @Override
    public void writeReports(String filepath) {
    }

    @Override
    public void closeLog() throws IOException {
        this.fout.close();
    }
}

