/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.log;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import org.smyld.log.LogStructure;

public class LogRecord
implements Serializable,
LogStructure {
    private static final long serialVersionUID = 1L;
    private String className;
    private String modName;
    private String message;
    private String startTime;
    private String endTime;
    private HashMap<String, String> fields = new HashMap();
    public static final String FLD_MESSAGE = "Message";
    public static final String FLD_MODULE_NAME = "ModuleName";
    public static final String FLD_CLASS_NAME = "ClassName";
    public static final String FLD_START_TIME = "StartTime";
    public static final String FLD_END_TIME = "EndTime";
    public static final String FLDHD_MESSAGE = "Message";
    public static final String FLDHD_MODULE_NAME = "Module Name";
    public static final String FLDHD_CLASS_NAME = "Class Name";
    public static final String FLDHD_START_TIME = "Start Time";
    public static final String FLDHD_END_TIME = "End Time";

    public LogRecord() {
        this.fields.put(FLD_CLASS_NAME, FLD_CLASS_NAME);
        this.fields.put(FLD_MODULE_NAME, FLD_MODULE_NAME);
        this.fields.put("Message", "Message");
        this.fields.put(FLD_START_TIME, FLD_START_TIME);
        this.fields.put(FLD_END_TIME, FLD_END_TIME);
    }

    public LogRecord(String message, String className) {
        this.setClassName(className);
        this.setMessage(message);
    }

    public LogRecord(String message, Class srouceClass) {
        this.setClassName(srouceClass.getName());
        this.setMessage(message);
    }

    public void reset() {
    }

    public String getClassName() {
        return this.getFieldValue(FLD_CLASS_NAME);
    }

    public String getModuleName() {
        return this.getFieldValue(FLD_MODULE_NAME);
    }

    public String getLogMessage() {
        return this.getFieldValue("Message");
    }

    public String getStartTime() {
        return this.getFieldValue(FLD_START_TIME);
    }

    public String getEndTime() {
        return this.getFieldValue(FLD_END_TIME);
    }

    public void setClassName(String name) {
        this.setField(FLD_CLASS_NAME, name);
    }

    public void setModuleName(String name) {
        this.setField(FLD_MODULE_NAME, name);
    }

    public void setMessage(String message) {
        this.setField("Message", message);
    }

    public void setStartTime(String time) {
        this.setField(FLD_START_TIME, time);
    }

    public void setEndTime(String time) {
        this.setField(FLD_END_TIME, time);
    }

    public String getFieldValue(String fieldName) {
        return this.fields.get(fieldName);
    }

    public void addField(String fieldName, String fieldValue) {
        this.fields.put(fieldName, fieldValue);
    }

    public void setField(String fieldName, String fieldValue) {
        this.fields.put(fieldName, fieldValue);
    }

    public String toString() {
        return this.className + "\t" + this.modName + "\t" + this.message + "\t" + this.startTime + "\t" + this.endTime + "\n";
    }

    @Override
    public Vector<String> getFieldsSeq() {
        Vector<String> fieldsSeq = new Vector<String>();
        fieldsSeq.add(FLD_CLASS_NAME);
        fieldsSeq.add(FLD_MODULE_NAME);
        fieldsSeq.add("Message");
        fieldsSeq.add(FLD_START_TIME);
        fieldsSeq.add(FLD_END_TIME);
        return fieldsSeq;
    }

    @Override
    public Vector<String> getFieldsHeader() {
        Vector<String> fieldsHdr = new Vector<String>();
        fieldsHdr.add(FLDHD_CLASS_NAME);
        fieldsHdr.add(FLDHD_MODULE_NAME);
        fieldsHdr.add("Message");
        fieldsHdr.add(FLDHD_START_TIME);
        fieldsHdr.add(FLDHD_END_TIME);
        return fieldsHdr;
    }
}

