/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.log;

import java.io.IOException;
import org.smyld.SMYLDObject;
import org.smyld.log.LogManager;
import org.smyld.log.LogRecord;

public class SMYLDDebugHandler
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    LogManager currentLogManager;
    int DebugLevel;
    int maximumDebugLevel;
    int echoDebugLevel;

    public SMYLDDebugHandler(LogManager systemLogManager, int MaximumDebugLevel) {
        this.currentLogManager = systemLogManager;
        this.maximumDebugLevel = MaximumDebugLevel;
    }

    public void echoToDebugLevel(int echoDebugLevel) {
        this.echoDebugLevel = echoDebugLevel;
    }

    public void addRecord(LogRecord record, int msgDebugLevel) {
        if (msgDebugLevel <= this.echoDebugLevel) {
            System.out.println(record.getLogMessage());
        }
        if (msgDebugLevel <= this.DebugLevel && msgDebugLevel <= this.maximumDebugLevel) {
            this.currentLogManager.addRecord(record);
        }
    }

    public void closeLog() throws IOException {
        this.currentLogManager.closeLog();
    }

    public int getDebugLevel() {
        return this.DebugLevel;
    }

    public void setDebugLevel(int DebugLevel) {
        this.DebugLevel = DebugLevel;
    }
}

