/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import org.smyld.net.ClientNodeTextListener;

public class ClientNode
implements Runnable {
    Socket clientSocket;
    PrintWriter out;
    BufferedReader in;
    boolean active = false;
    boolean close = false;
    long sleepTime;
    long activeSleepTime;
    long inActiveSleepTime;
    ClientNodeTextListener defaultListener;

    public ClientNode(Socket ClientSocket, long ActiveSleepTime, long InActiveSleepTime) {
        this.init(ClientSocket, ActiveSleepTime, InActiveSleepTime);
    }

    public int getPort() {
        return this.clientSocket.getPort();
    }

    public ClientNode(String destinationID, int destinationPortNo, long ActiveSleepTime, long InActiveSleepTime) throws Exception {
        Socket newClientSocket = new Socket(destinationID, destinationPortNo);
        this.init(newClientSocket, ActiveSleepTime, InActiveSleepTime);
    }

    private void init(Socket ClientSocket, long ActiveSleepTime, long InActiveSleepTime) {
        this.activeSleepTime = ActiveSleepTime;
        this.inActiveSleepTime = InActiveSleepTime;
        this.sleepTime = InActiveSleepTime;
        this.clientSocket = ClientSocket;
        try {
            this.out = new PrintWriter(this.clientSocket.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            this.active = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.active = false;
        }
    }

    private void textArrive(String text) {
        this.defaultListener.incomingText(this, text);
    }

    public void start() {
        Thread listenerThread = new Thread(this);
        listenerThread.start();
    }

    public String getIPAddress() {
        return this.clientSocket.getInetAddress().getHostAddress();
    }

    @Override
    public void run() {
        while (!this.close) {
            try {
                String incomingText = null;
                incomingText = this.in.readLine();
                if (incomingText != null) {
                    this.textArrive(incomingText);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.close();
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void addClientTextListener(ClientNodeTextListener newClientText) {
        this.defaultListener = newClientText;
    }

    public boolean sendText(String dataSent) {
        this.out.print(dataSent);
        this.out.flush();
        this.sleepTime = this.activeSleepTime;
        return true;
    }

    public void sendTextLine(String dataSent) {
        this.sendText(dataSent + "\n");
    }

    public void close() {
        this.close = true;
        this.active = false;
        try {
            this.in.close();
            this.clientSocket.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isActive() {
        return this.active;
    }
}

