/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.smyld.net.ClientNode;
import org.smyld.net.NewClientNodeListener;

public class ServerNode
extends ServerSocket
implements Runnable {
    boolean closeServer = false;
    boolean connectionEstablished = false;
    long connectedClientsSleepTime;
    long serverSleepTime;
    NewClientNodeListener defaultListener;

    public ServerNode(int Port, long ConnectedClientsSleepTime, long ServerSleepTime) throws IOException {
        super(Port);
        this.serverSleepTime = ServerSleepTime;
        this.connectedClientsSleepTime = ConnectedClientsSleepTime;
    }

    public ServerNode(int Port, long ConnectedClientsSleepTime) throws IOException {
        super(Port);
        this.serverSleepTime = 50L;
        this.connectedClientsSleepTime = ConnectedClientsSleepTime;
    }

    public void addNewClientListener(NewClientNodeListener clientListener) {
        this.defaultListener = clientListener;
    }

    @Override
    public void run() {
        while (!this.closeServer) {
            try {
                Socket newConn = this.accept();
                if (this.defaultListener != null) {
                    this.defaultListener.newClientNodeFound(new ClientNode(newConn, this.connectedClientsSleepTime, this.connectedClientsSleepTime * 2L));
                }
                Thread.sleep(this.serverSleepTime);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.closeServer = true;
        super.close();
    }

    public void newClientNodeFound(ClientNode newClientNode) {
    }
}

