/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.net;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Vector;
import org.smyld.SMYLDObject;
import org.smyld.io.FileSystem;
import org.smyld.net.InternetUtil;
import org.smyld.net.web.ItemLink;

public class WebCopier
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    String siteURL;
    String baseURL;
    String targetPath;
    boolean withImages;
    boolean allResources;
    Vector<ItemLink> pageReferences;
    Vector<ItemLink> items;
    String currentPage;
    StringBuffer buffer = new StringBuffer();
    int indexMove = 0;

    public void copyWebSite(String siteURL, String targetPath, boolean withImages, boolean allResources) {
        this.siteURL = siteURL;
        this.targetPath = targetPath;
        this.withImages = withImages;
        this.allResources = allResources;
        this.pageReferences = new Vector();
        this.items = new Vector();
        this.setBaseURL();
        this.startProcess();
    }

    private void startProcess() {
        this.currentPage = InternetUtil.getPageContents(this.siteURL);
        this.buffer.setLength(0);
        this.indexMove = 0;
        this.buffer.append(this.currentPage);
        this.resolveItems(this.items, "src=\"");
        this.resolveItems(this.pageReferences, "href=\"");
        this.processPageItems();
        this.processPageRef();
        try {
            FileOutputStream out = new FileOutputStream(this.targetPath + "index.html");
            out.write(this.buffer.toString().getBytes());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("hi");
    }

    private void setBaseURL() {
        this.baseURL = this.siteURL;
        String lastElement = this.siteURL;
        if (this.siteURL.startsWith("http://")) {
            lastElement = this.siteURL.substring(7);
        }
        if (lastElement.lastIndexOf("/") != -1 && (lastElement = lastElement.substring(lastElement.indexOf("/"))).indexOf(".") != -1) {
            this.baseURL = this.siteURL.substring(0, this.siteURL.lastIndexOf("/"));
        }
    }

    private void resolveItems(Vector<ItemLink> collection, String key) {
        int newKeyIndex = 0;
        while ((newKeyIndex = this.currentPage.indexOf(key, newKeyIndex + 1)) != -1) {
            int keyEndIndx = this.currentPage.indexOf("\"", newKeyIndex + key.length() + 1);
            if (keyEndIndx == -1) continue;
            String value = this.currentPage.substring(newKeyIndex + key.length(), keyEndIndx);
            ItemLink newItem = new ItemLink();
            newItem.setName(value);
            newItem.setStartIndex(newKeyIndex + key.length());
            newItem.setEndIndex(keyEndIndx);
            collection.add(newItem);
        }
    }

    private void processPageItems() {
        for (ItemLink item : this.items) {
            if (item == null) continue;
            this.processItem(item);
        }
    }

    private void processPageRef() {
        for (ItemLink item : this.pageReferences) {
            if (item == null) continue;
            this.processItem(item);
        }
    }

    private void processItem(ItemLink item) {
        String folder;
        if (item.getName().indexOf("/") != -1 && FileSystem.confirmFoldersExistence(folder = this.targetPath + File.separator + item.getName().substring(0, item.getName().lastIndexOf("/")))) {
            String realSource = this.getRealSource(item);
            InternetUtil.savePageItem(realSource, this.targetPath + item.getName());
        }
    }

    private String getRealSource(ItemLink item) {
        if (item.getName().startsWith("/")) {
            this.buffer = this.buffer.replace(item.getStartIndex() - this.indexMove, item.getEndIndex() - this.indexMove, item.getName().substring(1));
            ++this.indexMove;
            if (this.baseURL.indexOf("/", 8) != -1) {
                return this.baseURL.substring(0, this.baseURL.indexOf("/", 8)) + item.getName();
            }
            return this.baseURL + item.getName();
        }
        return this.baseURL + "/" + item.getName();
    }
}

