/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.net.url;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import org.smyld.SMYLDObject;
import org.smyld.net.url.ComProtocol;
import org.smyld.net.url.ProtocolConsts;
import org.smyld.net.url.ProtocolImpl;

public class URLConnector
extends SMYLDObject
implements ProtocolConsts {
    private static final long serialVersionUID = 1L;
    private URLConnection connection;
    protected URL serverURL;
    private String urlSuffix;
    private ProtocolImpl protParser;
    public static final String COMPROT_PROP_KEY = "COMPROT_KEY";
    public static final String COMPROT_PROP_VAL = "COMPROT_VAL";

    public URLConnector(URL connectURL) {
        this.serverURL = connectURL;
        this.protParser = new ProtocolImpl();
    }

    public URLConnector(String protocol, String host, int port, String urlSuffix) {
        this.initCon(protocol, host, port, urlSuffix);
        this.protParser = new ProtocolImpl();
    }

    public void setRequestProperty(String propertyName, String propertyValue) {
        if (this.connection == null) {
            this.startConnection();
        }
        if (propertyName == null) {
            System.out.println("Property name is null");
        }
        if (propertyValue == null) {
            System.out.println("Property value is null");
        }
        this.connection.setRequestProperty(propertyName, propertyValue);
    }

    public ComProtocol send(String header, Serializable body) {
        try {
            this.startConnection();
            this.setRequestProperty(COMPROT_PROP_KEY, COMPROT_PROP_VAL);
            this.protParser.setHeader(header);
            this.protParser.setBody(body);
            this.protParser.send(this.connection.getOutputStream());
            InputStream inStr = this.connection.getInputStream();
            if (inStr == null) {
                return null;
            }
            ObjectInputStream in = new ObjectInputStream(inStr);
            Object o = in.readObject();
            ComProtocol myProt = (ComProtocol)o;
            return myProt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void initCon(String prot, String host, int port, String file) {
        try {
            this.serverURL = new URL(prot, host, port, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startConnection() {
        try {
            this.connection = this.serverURL.openConnection();
            this.connection.setDoOutput(true);
            this.connection.setUseCaches(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

