/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.sys;

import java.util.HashMap;
import org.smyld.SMYLDObject;
import org.smyld.sys.OSGroup;
import org.smyld.sys.SystemConstants;
import org.smyld.sys.UnknownOS;

public class SMYLDSystem
extends SMYLDObject
implements SystemConstants {
    private static final long serialVersionUID = 1L;
    private static HashMap<String, String> OSMapper;

    public static OSGroup getOperatingSystemGroup() throws UnknownOS {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows")) {
            return OSGroup.Windows;
        }
        if (os.contains("mac")) {
            return OSGroup.MAC;
        }
        return OSGroup.Linux;
    }

    public static int getOperatingSystem() throws UnknownOS {
        String os = System.getProperty("os.name").toLowerCase();
        SMYLDSystem.initOSMapper();
        String resultantOS = OSMapper.get(os);
        if (resultantOS != null) {
            return Integer.parseInt(resultantOS);
        }
        throw new UnknownOS();
    }

    private static void initOSMapper() {
        OSMapper = new HashMap();
        OSMapper.put("AIX".toLowerCase(), Integer.toString(8));
        OSMapper.put("Digital Unix".toLowerCase(), Integer.toString(9));
        OSMapper.put("FreeBSD ".toLowerCase(), Integer.toString(10));
        OSMapper.put("HP UX".toLowerCase(), Integer.toString(11));
        OSMapper.put("Irix ".toLowerCase(), Integer.toString(12));
        OSMapper.put("Linux".toLowerCase(), Integer.toString(1));
        OSMapper.put("Mac OS".toLowerCase(), Integer.toString(13));
        OSMapper.put("MPE/iX".toLowerCase(), Integer.toString(14));
        OSMapper.put("Netware 4.11".toLowerCase(), Integer.toString(15));
        OSMapper.put("OS/2".toLowerCase(), Integer.toString(16));
        OSMapper.put("Solaris".toLowerCase(), Integer.toString(7));
        OSMapper.put("Windows 2000".toLowerCase(), Integer.toString(4));
        OSMapper.put("Windows 95".toLowerCase(), Integer.toString(6));
        OSMapper.put("Windows 98".toLowerCase(), Integer.toString(5));
        OSMapper.put("Windows NT".toLowerCase(), Integer.toString(3));
        OSMapper.put("Windows XP".toLowerCase(), Integer.toString(2));
        OSMapper.put("Windows 7".toLowerCase(), Integer.toString(18));
        OSMapper.put("Windows 10".toLowerCase(), Integer.toString(17));
    }
}

