/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.text;

import java.util.Vector;
import javax.swing.text.html.HTML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.smyld.xml.XMLFileWriter;
import org.smyld.xml.XMLUtil;

public class HTMLFileWriter
extends XMLFileWriter {
    private static final long serialVersionUID = 1L;
    Element bodyEl;
    Element headEl;
    String title;
    String headline;
    Vector<Element> elements;

    public HTMLFileWriter() {
        this.init();
    }

    private void init() {
        this.rootElement = new Element(HTML.Tag.HTML.toString());
        this.bodyEl = new Element(HTML.Tag.BODY.toString());
        this.headEl = new Element(HTML.Tag.HEAD.toString());
        this.elements = new Vector();
    }

    @Override
    public void compose() {
        XMLUtil.addChildElement(this.headEl, HTML.Tag.TITLE.toString(), this.getTitle());
        XMLUtil.addChildElement(this.bodyEl, HTML.Tag.H1.toString(), this.getHeadline());
        for (Element curEl : this.elements) {
            this.bodyEl.addContent((Content)curEl);
        }
        this.rootElement.addContent((Content)this.headEl);
        this.rootElement.addContent((Content)this.bodyEl);
    }

    public void addParagraph(String contents) {
        Element newPara = new Element(HTML.Tag.P.toString());
        newPara.setText(contents);
        this.elements.add(newPara);
    }

    public void addLink(String linkTarget, String linkText) {
        Element newLink = new Element(HTML.Tag.A.toString());
        newLink.setAttribute("href", linkTarget);
        newLink.setText(linkText);
        this.elements.add(newLink);
    }

    public void addImage(String imageSource) {
        Element newImage = new Element(HTML.Tag.IMG.toString());
        newImage.setAttribute("src", imageSource);
        this.elements.add(newImage);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getHeadline() {
        return this.headline;
    }

    public void setHeadline(String headline) {
        this.headline = headline;
    }
}

