/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.text;

import java.util.Arrays;
import java.util.Vector;
import org.smyld.SMYLDObject;

public class MultiTextTokenizer
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    String text;
    String[] separators;
    int[] separatorsFound;
    boolean withSeparators;

    public MultiTextTokenizer(String[] Separators, boolean WithSeparators) {
        this.separators = Separators;
        this.withSeparators = WithSeparators;
    }

    public MultiTextTokenizer(String Text2, String[] Separators, boolean WithSeparators) {
        this(Separators, WithSeparators);
        this.setText(Text2);
    }

    public void setText(String Text2) {
        this.text = Text2.trim();
        this.separatorsFound = new int[this.text.length()];
    }

    public String[] parseTokens() {
        Vector<String> tokenz = new Vector<String>();
        int[] resultantIndex = null;
        int separatorsNo = this.fillIndexes();
        if (separatorsNo > 0) {
            resultantIndex = new int[separatorsNo];
            System.arraycopy(this.separatorsFound, 0, resultantIndex, 0, separatorsNo);
            Arrays.sort(resultantIndex);
            int lastIndex = 0;
            int elementsJump = 1;
            if (this.withSeparators) {
                elementsJump = 0;
            }
            for (int i = 0; i < resultantIndex.length; i += 1 + elementsJump) {
                tokenz.add(this.text.substring(lastIndex, resultantIndex[i]));
                lastIndex = resultantIndex[i + elementsJump];
            }
            tokenz.add(this.text.substring(resultantIndex[resultantIndex.length - 1], this.text.length()));
        }
        Object[] result = new String[tokenz.size()];
        tokenz.copyInto(result);
        return result;
    }

    protected int fillIndexes() {
        int fromIndex = 0;
        int foundIndex = 0;
        for (int i = 0; i < this.separators.length; ++i) {
            while ((fromIndex = this.text.indexOf(this.separators[i], fromIndex)) != -1) {
                this.separatorsFound[foundIndex] = fromIndex;
                this.separatorsFound[foundIndex + 1] = fromIndex + this.separators[i].length();
                foundIndex += 2;
                ++fromIndex;
            }
        }
        return foundIndex;
    }
}

