/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util.keyboard;

import java.io.ByteArrayOutputStream;
import org.smyld.SMYLDObject;
import org.smyld.util.keyboard.KeyboardConverter;

public class BasicKeyboardConverter
extends SMYLDObject
implements KeyboardConverter {
    private static final long serialVersionUID = 1L;
    byte[][] convertKeySet;
    String targetCode;
    String sourceKeyboardName;
    String targetKeyboardName;

    @Override
    public String convertKeys(String incomingText) throws Exception {
        return new String(this.convertKeysToBytes(incomingText), this.targetCode);
    }

    @Override
    public byte[] convertKeysToBytes(String incomingText) throws Exception {
        System.out.println(new String(incomingText.getBytes("windows-1256")));
        byte[] letters = incomingText.getBytes();
        int incKeyLength = letters.length;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        for (int i = 0; i < incKeyLength; ++i) {
            bout.write(this.detectKey(letters[i]));
        }
        return bout.toByteArray();
    }

    private byte[] detectKey(byte incKey) {
        byte[] result = new byte[]{incKey};
        if (incKey != 32) {
            for (int i = 0; i < this.convertKeySet.length; ++i) {
                if (this.convertKeySet[i][0] != incKey) continue;
                result = new byte[this.convertKeySet[i].length - 1];
                for (int j = 1; j < this.convertKeySet[i].length; ++j) {
                    result[j - 1] = this.convertKeySet[i][j];
                }
                return result;
            }
        }
        return result;
    }

    private int getLength(byte incKey) {
        int length = 1;
        for (int i = 0; i < this.convertKeySet.length; ++i) {
            if (this.convertKeySet[i][0] != incKey) continue;
            return this.convertKeySet[i].length - 1;
        }
        return length;
    }

    void init() {
    }

    @Override
    public String getTargetCharSetName() {
        return this.targetCode;
    }

    @Override
    public String getSourceKeyboardName() {
        return this.sourceKeyboardName;
    }

    @Override
    public String getTargetKeyboardName() {
        return this.targetKeyboardName;
    }
}

