/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.smyld.SMYLDObject;

public abstract class XMLFileWriter
extends SMYLDObject {
    protected Element rootElement;
    protected String fileName;

    public void writeFileToPath(String filePath) throws IOException {
        String fileName = filePath + this.getFileName();
        this.writeFileTo(fileName);
    }

    public void writeFileTo(String fullFileName) throws IOException {
        FileOutputStream fout = new FileOutputStream(fullFileName);
        this.writeFileToStream(fout);
    }

    protected abstract void compose();

    protected void dumpFile() {
        this.compose();
    }

    public void writeFileToStream(OutputStream out) throws IOException {
        this.compose();
        XMLOutputter output = new XMLOutputter();
        output.setFormat(Format.getPrettyFormat().setTextMode(Format.TextMode.NORMALIZE));
        output.output(this.rootElement, out);
        out.close();
    }

    public Element getRootElement() {
        this.compose();
        return this.rootElement;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

