/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.net;

import java.io.IOException;
import java.util.HashMap;
import org.smyld.SMYLDObject;
import org.smyld.net.ClientNode;
import org.smyld.net.ClientNodeTextListener;
import org.smyld.net.NetProtocol;
import org.smyld.net.NewClientNodeListener;
import org.smyld.net.ServerNode;

public class ServerImpl
extends SMYLDObject
implements NewClientNodeListener,
ClientNodeTextListener {
    private static final long serialVersionUID = 1L;
    protected NetProtocol serverNetProtocol;
    ServerNode serverSock;
    HashMap<String, ClientNode> connectedClients;
    int maxClientNo;
    int currentConnectingClients;

    public ServerImpl(int port, long textListeningSleepTime, int MaximumConnectingClient, NetProtocol ServerNetProtocol) throws IOException {
        this.serverNetProtocol = ServerNetProtocol;
        this.maxClientNo = MaximumConnectingClient;
        this.connectedClients = new HashMap();
        this.serverSock = new ServerNode(port, textListeningSleepTime);
        this.serverSock.addNewClientListener(this);
        Thread serverThread = new Thread(this.serverSock);
        serverThread.start();
    }

    @Override
    public void newClientNodeFound(ClientNode newClientNode) {
        ++this.currentConnectingClients;
        if (this.currentConnectingClients <= this.maxClientNo) {
            newClientNode.addClientTextListener(this);
            newClientNode.start();
            newClientNode.sendText(this.serverNetProtocol.getWelcomeMessage());
            this.connectedClients.put(newClientNode.getIPAddress(), newClientNode);
        } else {
            newClientNode.sendText(this.serverNetProtocol.getConnectionNoOver());
            newClientNode.close();
        }
    }

    @Override
    public void incomingText(ClientNode sourceNode, String newText) {
        this.serverNetProtocol.processMessage(sourceNode, newText);
    }

    public void sendText(String clientIPAddress, String sentText) {
        ClientNode targetClient = null;
        targetClient = this.connectedClients.get(clientIPAddress);
        if (targetClient != null) {
            targetClient.sendText(sentText);
        }
    }

    public void sendTextLineToALL(String sentText) {
        for (ClientNode targetClient : this.connectedClients.values()) {
            targetClient.sendTextLine(sentText);
        }
    }

    public void close() throws IOException {
        this.serverSock.close();
        this.connectedClients.clear();
        this.currentConnectingClients = 0;
    }
}

