/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.smyld.math.HexaHandler;

public class HashHandler {
    MessageDigest dig = null;
    String type = null;
    HexaHandler hexHandler = new HexaHandler();
    public static final String HASH_TYPE_MD5 = "MD5";
    public static final String HASH_TYPE_SHA1 = "SHA-1";

    public HashHandler(String type) {
        this.type = type;
        this.init();
    }

    private void init() {
        try {
            this.dig = MessageDigest.getInstance(this.type);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("NoSuchAlgorithmException caught!");
            System.exit(-1);
        }
    }

    public String encode(String value) {
        byte[] byteHash = null;
        this.dig.reset();
        this.dig.update(value.getBytes());
        byteHash = this.dig.digest();
        StringBuilder resultString = new StringBuilder();
        Object hexConverted = null;
        for (byte curByte : byteHash) {
            resultString.append(this.hexHandler.toHexString(curByte));
        }
        return resultString.toString();
    }

    public boolean match(String encoded, String plainText) {
        return encoded.equals(this.encode(plainText));
    }
}

