/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.text;

import org.smyld.SMYLDObject;
import org.smyld.text.StringReader;

public class SimpleStringNavigator
extends SMYLDObject
implements StringReader {
    private static final long serialVersionUID = 1L;
    int curPointer;
    String textValue;

    public SimpleStringNavigator(String textValue) {
        this.setText(textValue);
    }

    public void setText(String newValue) {
        this.textValue = newValue;
        this.curPointer = 0;
    }

    public char getChar() {
        char targetChar = ' ';
        if (this.curPointer + 1 <= this.textValue.length()) {
            targetChar = this.textValue.charAt(this.curPointer);
            ++this.curPointer;
        }
        return targetChar;
    }

    @Override
    public String getText(int charNo, int code) {
        return this.getText(charNo);
    }

    @Override
    public String getText(int charNo) {
        String targetValue = null;
        if (this.curPointer + charNo <= this.textValue.length()) {
            targetValue = this.textValue.substring(this.curPointer, this.curPointer + charNo);
            this.curPointer += charNo;
        } else if (this.curPointer < this.textValue.length()) {
            targetValue = this.textValue.substring(this.curPointer);
            this.curPointer = this.textValue.length();
        }
        return targetValue;
    }

    @Override
    public void jump(int stepsNo) {
        if (stepsNo >= 0) {
            this.curPointer += stepsNo;
        }
    }

    @Override
    public String getText() {
        return this.textValue;
    }
}

