/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.text;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.smyld.io.StreamReader;
import org.smyld.text.StringReader;

public class StringNavigator
implements StringReader {
    FileInputStream fin = null;
    private boolean endOfText = false;
    private StreamReader fileReader;
    private InputStream inpStream;
    private boolean readIsSegmented = false;
    private int readBlockSize = 1024;
    private int blockDelimSize = 2;
    private boolean withDelimiter = false;
    private String text;
    private String residualText;
    private String lastText;
    private int pointer = 0;
    private long filePointer = 0L;
    boolean fixedBlockRead = false;
    public static final int DEFAULT_DATA_BLOCK_SIZE = 1024;
    public static final int DEFAULT_DATA_BLOCK_DELIM_SIZE = 2;

    public StringNavigator(String Text2) {
        this.setText(Text2);
        this.fixedBlockRead = true;
    }

    public StringNavigator(File textFile) throws IOException {
        try {
            this.fileReader = new StreamReader(textFile);
            this.setText(this.fileReader.read());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Error extracting the text from the file");
        }
    }

    public StringNavigator(File textFile, int dataBlockSize) throws IOException {
        this(new FileInputStream(textFile), dataBlockSize);
    }

    public StringNavigator(InputStream dataStream, int dataBlockSize) throws IOException {
        try {
            if (dataBlockSize <= 0) {
                throw new IOException("Not Suitable data size");
            }
            this.readBlockSize = dataBlockSize;
            this.readIsSegmented = true;
            this.fileReader = new StreamReader(dataStream);
            this.doReadData();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Error extracting the text from the file");
        }
    }

    public void close() throws Exception {
    }

    @Override
    public String getText(int charNo, int code) {
        return this.getText(charNo);
    }

    @Override
    public String getText(int charNo) {
        this.lastText = "";
        if (charNo > 0) {
            this.filePointer += (long)charNo;
            if (this.pointer + charNo >= this.text.length()) {
                this.lastText = this.residualText = this.text.substring(this.pointer, this.text.length());
                if (!this.fixedBlockRead) {
                    int newBlockPart = charNo - this.residualText.length();
                    if (this.doReadData() && newBlockPart != 0) {
                        this.filePointer -= (long)newBlockPart;
                        this.lastText = this.lastText + this.getText(newBlockPart);
                    }
                } else {
                    this.endOfText = true;
                }
            } else if (this.pointer < 0) {
                int rsidualLength = this.residualText.length();
                String leftPart = this.residualText.substring(rsidualLength + this.pointer);
                this.pointer = 0;
                this.lastText = leftPart + this.text.substring(this.pointer, this.pointer + (charNo += this.pointer));
                this.pointer = charNo;
            } else {
                this.lastText = this.text.substring(this.pointer, this.pointer + charNo);
                this.pointer += charNo;
            }
        }
        return this.lastText;
    }

    private boolean doReadData() {
        boolean readResult = true;
        if (this.fixedBlockRead) {
            this.endOfText = true;
        } else {
            if (this.isWithDelimiter()) {
                this.fileReader.read(this.blockDelimSize);
                this.filePointer += (long)this.blockDelimSize;
            }
            this.text = this.fileReader.read(this.readBlockSize);
            if (this.text == null) {
                this.endOfText = true;
                readResult = false;
            } else {
                this.pointer = 0;
            }
        }
        return readResult;
    }

    @Override
    public void jump(int stepNo) {
        this.filePointer += (long)stepNo;
        if (this.pointer + stepNo > this.text.length()) {
            int newBlockPart;
            int diff = this.readBlockSize - this.pointer;
            this.pointer = newBlockPart = stepNo - diff;
            this.doReadData();
        } else {
            this.pointer += stepNo;
        }
    }

    public boolean EndOfValue() {
        return this.endOfText;
    }

    public int availableCharacters() {
        int restLength = this.getText().length() - this.pointer - 1;
        return restLength;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.reset();
        this.text = newText;
        this.fixedBlockRead = true;
    }

    public void reset() {
        this.endOfText = false;
        this.readIsSegmented = false;
        this.fixedBlockRead = false;
        this.pointer = 0;
        this.filePointer = 0L;
    }

    public long getPosition() {
        return this.filePointer;
    }

    public void setDataBlockSize(int newBlockSize) {
        this.readBlockSize = newBlockSize;
    }

    public void setDataBlockDelimiterSize(int newDelimiterSize) {
        this.blockDelimSize = newDelimiterSize;
    }

    public void setWithDelimiter(boolean WithDelimiter) {
        this.withDelimiter = WithDelimiter;
    }

    public int getDataBlockSize() {
        return this.readBlockSize;
    }

    public int getDataBlockDelimiterSize() {
        return this.blockDelimSize;
    }

    public boolean isWithDelimiter() {
        return this.withDelimiter;
    }

    public String getLastReadText() {
        return this.lastText;
    }
}

