/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util;

import org.smyld.SMYLDObject;

public class ProcessTimeCalculator
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    long minTime = -1L;
    long maxTime = -1L;
    long totalTime;
    long curTime;
    String processName;

    public ProcessTimeCalculator(String processName) {
        this.processName = processName;
    }

    public void processStart() {
        this.curTime = System.currentTimeMillis();
    }

    public void processEnd() {
        this.calculateEndOfTranProcessTime(System.currentTimeMillis() - this.curTime);
    }

    private void calculateEndOfTranProcessTime(long curPeriod) {
        if (this.minTime == -1L) {
            this.minTime = curPeriod;
        }
        if (this.maxTime == -1L) {
            this.maxTime = curPeriod;
        }
        if (curPeriod > this.maxTime) {
            this.maxTime = curPeriod;
        }
        if (curPeriod < this.minTime) {
            this.minTime = curPeriod;
        }
        this.totalTime += curPeriod;
        this.curTime = 0L;
    }

    public void printTimeResults() {
        System.out.println("Process " + this.processName + " time results :");
        System.out.println("Total   time " + this.totalTime);
        System.out.println("Maximum time " + this.maxTime);
        System.out.println("Minimum time " + this.minTime);
    }

    public void reset() {
        this.maxTime = 0L;
        this.minTime = 0L;
        this.totalTime = 0L;
        this.curTime = 0L;
    }

    public long getTotalProcessingTime() {
        return this.totalTime;
    }

    public long getMaximumProcessingTime() {
        return this.maxTime;
    }

    public long getMinimumProcessingTime() {
        return this.minTime;
    }
}

