/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class SMYLDDate
extends Date {
    private static final long serialVersionUID = 1L;
    private String originalFormat = "yyyyMMdd";
    private String textValue;
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat(this.originalFormat);
    private boolean correct = true;
    public static final String FRM_yyyyMMdd = "yyyyMMdd";
    public static final String FRM_yyyyMM = "yyyyMM";
    public static final String FRM_yyMMddHHmmss = "yyMMddHHmmss";
    public static final String FRM_yyDDD = "yyDDD";
    public static final String FRM_yyDDD_HHmmss = "yyDDD-HHmmss";
    public static final String FRM_yyyyMMdd_SEP_2points = "yyyy:MM:dd";
    public static final String FRM_MMddyyyy_SEP_slash = "MM/dd/yyyy";
    public static final String FRM_HHmmss = "HHmmss";
    public static final String FRM_HHmmss_SEP_2points = "HH:mm:ss";
    public static final String FRM_yyMM = "yyMM";
    public static final String FRM_MMdd = "MMdd";
    public static final String FRM_MMddyy = "MMddyy";
    public static final String FRM_ddMMyy = "ddMMyy";
    public static final String FRM_yyMMdd = "yyMMdd";
    public static final String FRM_yyyy = "yyyy";
    public static final String FRM_DDD = "DDD";
    public static final String FRM_HH = "HH";
    public static final String FRM_mm = "mm";
    public static final String FRM_ss = "ss";
    public static final String FRM_MM = "MM";
    public static final String FRM_ddMMMyy_SEP_MINUS = "dd-MMM-yy";
    public static final String FRM_MMMyyyy_SEP_MINUS = "MMM-yyyy";
    public static final String FRM_MMM = "MMM";
    public static final String FRM_ddMMMyy_yyHHmmss_SEP_MINUS = "dd-MMM-yyHHmmss";
    public static final String FRM_yyyyMMddHHmmss_SEP_2points = "yyyyMMddHH:mm:ss";

    public SMYLDDate() {
    }

    public SMYLDDate(String dateFormat) {
        this.setFormat(dateFormat);
        this.dateFormatter.setLenient(false);
    }

    public SMYLDDate(String dateFormat, String dateValue) {
        this.setValue(dateValue, dateFormat);
        this.dateFormatter.setLenient(false);
    }

    public void setLenient(boolean value) {
        this.dateFormatter.setLenient(value);
    }

    public void setFormat(String newFormat) {
        this.dateFormatter.applyPattern(newFormat);
        this.originalFormat = newFormat;
    }

    @Override
    public void setTime(long newTime) {
        super.setTime(newTime);
        this.correct = true;
    }

    public void setValue(String newValue) {
        this.textValue = newValue;
        if (SMYLDDate.isAcceptableValue(newValue)) {
            try {
                this.setTime(this.dateFormatter.parse(newValue).getTime());
            }
            catch (Exception ex) {
                this.correct = false;
            }
        } else {
            this.correct = false;
        }
    }

    public void setValue(String newValue, String valueFormat) {
        this.setFormat(valueFormat);
        this.setValue(newValue);
    }

    public boolean isCorrect() {
        return this.correct;
    }

    public static boolean isAcceptableValue(String value) {
        if (value != null && value.trim().length() != 0) {
            try {
                if (Integer.parseInt(value) == 0) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.isCorrect()) {
            return this.dateFormatter.format(this);
        }
        return null;
    }

    public String toString(String DateFormat2) {
        if (this.isCorrect()) {
            this.dateFormatter.applyPattern(DateFormat2);
            String resultantDate = this.dateFormatter.format(this);
            this.dateFormatter.applyPattern(this.originalFormat);
            return resultantDate;
        }
        return null;
    }

    public SMYLDDate getDateAs(String DateFormat2) {
        SMYLDDate targetDate = null;
        try {
            targetDate = new SMYLDDate(DateFormat2, this.toString(DateFormat2));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return targetDate;
    }

    public long getTimeSinceMidNight() {
        long resultedMilliSeconds = -1L;
        GregorianCalendar currentCalendar = (GregorianCalendar)Calendar.getInstance();
        currentCalendar.setTime(this);
        resultedMilliSeconds = (currentCalendar.get(11) * 60 + currentCalendar.get(12)) * 60 + currentCalendar.get(13);
        return resultedMilliSeconds;
    }

    public String getFormat() {
        return this.originalFormat;
    }

    public static long getDayInMilliseconds() {
        return 86400000L;
    }

    public static long getDaysInMilliseconds(int days) {
        return (long)days * SMYLDDate.getDayInMilliseconds();
    }

    public String getTextValue() {
        return this.textValue;
    }
}

