/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.deploy.web;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.smyld.deploy.web.WebFileWriter;
import org.smyld.util.jar.SMYLDJARWriter;

public class SMYLDWARWriter
extends SMYLDJARWriter {
    protected WebFileWriter webSettingsFile;
    public static final String PATH_LIB = "WEB-INF/lib/";
    public static final String PATH_WEB = "WEB-INF/";

    public SMYLDWARWriter(OutputStream out) throws IOException {
        super(out);
        this.init();
    }

    public SMYLDWARWriter(String outName) throws IOException {
        super(outName);
        this.init();
    }

    private void init() {
        this.webSettingsFile = new WebFileWriter();
    }

    public void compose() {
        try {
            this.addXMLFile(this.webSettingsFile.getRootElement(), PATH_WEB + this.webSettingsFile.getFileName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dumpFile() throws IOException {
        this.compose();
        this.close();
    }

    public void addRefLibrary(String libraryName) throws Exception {
        if (libraryName == null) {
            if (!libraryName.toLowerCase().endsWith("jar")) {
                throw new Exception("Wrong library name!");
            }
            File libFile = new File(libraryName);
            if (libFile.exists()) {
                this.addFile(libraryName, PATH_LIB + libFile.getName());
            }
        }
    }

    public WebFileWriter getWebSettingsFile() {
        return this.webSettingsFile;
    }

    public void setWebSettingsFile(WebFileWriter webSettingsFile) {
        this.webSettingsFile = webSettingsFile;
    }
}

