/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import org.smyld.SMYLDObject;

public class SMYLDFileFilter
extends SMYLDObject
implements FilenameFilter {
    private static final long serialVersionUID = 1L;
    String FilePattern;
    String[] FilePatterns;
    protected HashMap<String, String> acceptedFiles;
    protected HashMap<String, String> informedFiles;
    boolean informOnce;

    public SMYLDFileFilter(String smyldFilePattern, boolean InformOnce) {
        this.FilePattern = smyldFilePattern;
        this.informOnce = InformOnce;
    }

    public SMYLDFileFilter(String[] smyldFilePatterns, boolean InformOnce) {
        this.FilePatterns = smyldFilePatterns;
        this.informOnce = InformOnce;
    }

    public HashMap<String, String> getAcceptedFiles() {
        return this.acceptedFiles;
    }

    public void clearAcceptedFiles() {
        if (this.acceptedFiles != null) {
            this.acceptedFiles.clear();
        }
    }

    protected void addAcceptedFile(String name, String pattern) {
        if (this.acceptedFiles == null) {
            this.acceptedFiles = new HashMap();
        }
        if (this.informOnce) {
            if (this.informedFiles == null) {
                this.informedFiles = new HashMap();
            }
            if (this.informedFiles.get(name) == null) {
                this.informedFiles.put(name, pattern);
                this.acceptedFiles.put(name, pattern);
            }
        } else {
            this.acceptedFiles.put(name, pattern);
        }
    }

    public String getFilePattern() {
        return this.FilePattern;
    }

    public String[] getFilePatterns() {
        return this.FilePatterns;
    }

    @Override
    public boolean accept(File dir, String name) {
        return name.length() == this.FilePattern.length();
    }
}

