/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.math;

public class HexaHandler {
    private String value;
    private static StringBuffer buffHexFrmAsc;
    private static StringBuffer buffBinValue;
    private static StringBuffer buffParseValue;
    private static StringBuffer buffConvToBinValue;
    private static final String HexValues = "0123456789ABCDEFabcdef";
    private static final String hex_bin_0 = "0000";
    private static final String hex_bin_1 = "0001";
    private static final String hex_bin_2 = "0010";
    private static final String hex_bin_3 = "0011";
    private static final String hex_bin_4 = "0100";
    private static final String hex_bin_5 = "0101";
    private static final String hex_bin_6 = "0110";
    private static final String hex_bin_7 = "0111";
    private static final String hex_bin_8 = "1000";
    private static final String hex_bin_9 = "1001";
    private static final String hex_bin_a = "1010";
    private static final String hex_bin_b = "1011";
    private static final String hex_bin_c = "1100";
    private static final String hex_bin_d = "1101";
    private static final String hex_bin_e = "1110";
    private static final String hex_bin_f = "1111";
    private static final String[] hexLookup;

    public HexaHandler(String hexData) throws NumberFormatException {
        if (!this.isHex(hexData)) {
            throw new NumberFormatException("Invalid Hexadeciaml characters in parsing (" + hexData + ") value.");
        }
        this.value = hexData.toLowerCase();
    }

    public HexaHandler() throws NumberFormatException {
    }

    public String toBinary() {
        return this.convertToBinary(this.value);
    }

    public byte[] toByte() {
        byte[] byteResult = new byte[this.value.length() / 2];
        String currentHexValue = null;
        int idx = 0;
        int curValue = 0;
        for (int i = 0; i < this.value.length(); i += 2) {
            currentHexValue = this.value.substring(i, i + 2);
            curValue = Integer.parseInt(currentHexValue, 16);
            byteResult[idx] = (byte)Math.abs(curValue);
            ++idx;
        }
        return byteResult;
    }

    public String convertToBinary(String HexaTextValue) {
        if (HexaTextValue == null) {
            return null;
        }
        buffConvToBinValue = this.doInitBuffer(buffConvToBinValue);
        Object currentBinValue = null;
        HexaTextValue = HexaTextValue.toLowerCase();
        for (int i = 0; i < HexaTextValue.length(); ++i) {
            char currentDigit = HexaTextValue.charAt(i);
            buffConvToBinValue.append(this.getBinaryValueText(currentDigit));
        }
        return buffConvToBinValue.toString();
    }

    public String getBinaryValueText(char hexaChar) {
        String resultantBinValue = null;
        switch (hexaChar) {
            case '0': {
                resultantBinValue = hex_bin_0;
                break;
            }
            case '1': {
                resultantBinValue = hex_bin_1;
                break;
            }
            case '2': {
                resultantBinValue = hex_bin_2;
                break;
            }
            case '3': {
                resultantBinValue = hex_bin_3;
                break;
            }
            case '4': {
                resultantBinValue = hex_bin_4;
                break;
            }
            case '5': {
                resultantBinValue = hex_bin_5;
                break;
            }
            case '6': {
                resultantBinValue = hex_bin_6;
                break;
            }
            case '7': {
                resultantBinValue = hex_bin_7;
                break;
            }
            case '8': {
                resultantBinValue = hex_bin_8;
                break;
            }
            case '9': {
                resultantBinValue = hex_bin_9;
                break;
            }
            case 'a': {
                resultantBinValue = hex_bin_a;
                break;
            }
            case 'b': {
                resultantBinValue = hex_bin_b;
                break;
            }
            case 'c': {
                resultantBinValue = hex_bin_c;
                break;
            }
            case 'd': {
                resultantBinValue = hex_bin_d;
                break;
            }
            case 'e': {
                resultantBinValue = hex_bin_e;
                break;
            }
            case 'f': {
                resultantBinValue = hex_bin_f;
            }
        }
        return resultantBinValue;
    }

    public String toHexString(int integerValue) {
        if (integerValue > 256 || integerValue < 0) {
            return null;
        }
        return hexLookup[integerValue];
    }

    public String toHexString(byte byteValue) {
        return this.toHexString(0xFF & byteValue);
    }

    public String toHexString(byte[] byteValues) {
        StringBuilder buff = new StringBuilder();
        for (byte curByte : byteValues) {
            buff.append(this.toHexString(curByte));
        }
        return buff.toString();
    }

    public String getHexaFromAscii(String acsiiText) {
        buffHexFrmAsc = this.doInitBuffer(buffHexFrmAsc);
        byte[] data = acsiiText.getBytes();
        for (int i = 0; i < data.length; ++i) {
            buffHexFrmAsc.append(this.toHexString(data[i]));
        }
        return buffHexFrmAsc.toString();
    }

    public String parse(String textValue) {
        return this.parse(textValue.getBytes());
    }

    public String parse(byte[] byteValue) {
        buffParseValue = this.doInitBuffer(buffParseValue);
        for (int i = 0; i < byteValue.length; ++i) {
            buffParseValue.append(this.toHexString(byteValue[i]));
        }
        return buffParseValue.toString();
    }

    private StringBuffer doInitBuffer(StringBuffer buffer) {
        if (buffer == null) {
            buffer = new StringBuffer();
        } else {
            buffer.setLength(0);
        }
        return buffer;
    }

    private boolean isHex(String testData) {
        for (int i = 0; i < testData.length(); ++i) {
            if (HexValues.indexOf(testData.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public String parseBinaryValueText(String binaryValue) {
        buffBinValue = this.doInitBuffer(buffBinValue);
        for (int i = 0; i < binaryValue.length(); i += 4) {
            buffBinValue.append(this.getHexFromBinary(binaryValue.substring(i, i + 4)));
        }
        return buffBinValue.toString();
    }

    public String getHexFromBinary(String binaryValue) {
        if (binaryValue.equals(hex_bin_0)) {
            return "0";
        }
        if (binaryValue.equals(hex_bin_1)) {
            return "1";
        }
        if (binaryValue.equals(hex_bin_2)) {
            return "2";
        }
        if (binaryValue.equals(hex_bin_3)) {
            return "3";
        }
        if (binaryValue.equals(hex_bin_4)) {
            return "4";
        }
        if (binaryValue.equals(hex_bin_5)) {
            return "5";
        }
        if (binaryValue.equals(hex_bin_6)) {
            return "6";
        }
        if (binaryValue.equals(hex_bin_7)) {
            return "7";
        }
        if (binaryValue.equals(hex_bin_8)) {
            return "8";
        }
        if (binaryValue.equals(hex_bin_9)) {
            return "9";
        }
        if (binaryValue.equals(hex_bin_a)) {
            return "a";
        }
        if (binaryValue.equals(hex_bin_b)) {
            return "b";
        }
        if (binaryValue.equals(hex_bin_c)) {
            return "c";
        }
        if (binaryValue.equals(hex_bin_d)) {
            return "d";
        }
        if (binaryValue.equals(hex_bin_e)) {
            return "e";
        }
        if (binaryValue.equals(hex_bin_f)) {
            return "f";
        }
        return null;
    }

    static {
        hexLookup = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0a", "0b", "0c", "0d", "0e", "0f", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1a", "1b", "1c", "1d", "1e", "1f", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2a", "2b", "2c", "2d", "2e", "2f", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3a", "3b", "3c", "3d", "3e", "3f", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4a", "4b", "4c", "4d", "4e", "4f", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5a", "5b", "5c", "5d", "5e", "5f", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6a", "6b", "6c", "6d", "6e", "6f", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7a", "7b", "7c", "7d", "7e", "7f", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8a", "8b", "8c", "8d", "8e", "8f", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9a", "9b", "9c", "9d", "9e", "9f", "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "aa", "ab", "ac", "ad", "ae", "af", "b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "b9", "ba", "bb", "bc", "bd", "be", "bf", "c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "ca", "cb", "cc", "cd", "ce", "cf", "d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9", "da", "db", "dc", "dd", "de", "df", "e0", "e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8", "e9", "ea", "eb", "ec", "ed", "ee", "ef", "f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "fa", "fb", "fc", "fd", "fe", "ff"};
    }
}

