/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.text;

import java.util.Vector;
import org.smyld.SMYLDObject;

public class BracketsParser
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    String text;
    char openingBracket;
    char closingBracket;
    int[][] foundBrackets;
    Vector<String> foundBracketText;
    boolean withSeparator;

    public BracketsParser(char OpeningBracket, char ClosingBracket, boolean WithSeparator) {
        this.closingBracket = ClosingBracket;
        this.openingBracket = OpeningBracket;
        this.foundBrackets = new int[50][2];
        this.foundBracketText = new Vector();
        this.withSeparator = WithSeparator;
    }

    public BracketsParser(String Text2, char OpeningBracket, char ClosingBracket, boolean WithSeparator) {
        this(OpeningBracket, ClosingBracket, WithSeparator);
        this.text = Text2;
    }

    public void reset() {
        this.foundBracketText.clear();
    }

    public void setText(String newText) {
        this.text = newText;
    }

    public Object[] parseBracket() {
        int resultantBrakets = this.fillIndex(this.text.toCharArray(), this.foundBrackets);
        for (int j = 0; j < resultantBrakets; ++j) {
            this.foundBracketText.add(this.text.substring(this.foundBrackets[j][0] + 1, this.foundBrackets[j][1]));
            if (!this.withSeparator || j >= resultantBrakets - 1) continue;
            this.foundBracketText.add(this.text.substring(this.foundBrackets[j][1] + 1, this.foundBrackets[j + 1][0]).trim());
        }
        if (this.foundBracketText.size() > 0) {
            return this.foundBracketText.toArray();
        }
        return null;
    }

    public int fillIndex(char[] textChars, int[][] bracketIndex) {
        int foundIndex = 0;
        int internalBrackets = 0;
        boolean startCounting = false;
        for (int i = 0; i < textChars.length; ++i) {
            if (textChars[i] == this.openingBracket) {
                if (!startCounting) {
                    bracketIndex[foundIndex][0] = i;
                    startCounting = true;
                    continue;
                }
                ++internalBrackets;
                continue;
            }
            if (textChars[i] != this.closingBracket || !startCounting) continue;
            if (internalBrackets > 0) {
                --internalBrackets;
                continue;
            }
            bracketIndex[foundIndex][1] = i;
            startCounting = false;
            ++foundIndex;
        }
        return foundIndex;
    }
}

