/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.text;

import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import org.smyld.SMYLDObject;
import org.smyld.io.StreamReader;
import org.smyld.math.HexaDecimal;

public class TextDecoder
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    public static final int CODE_EBCDIC = 1;
    public static final int CODE_BCD = 2;
    public static final int CODE_ASCII = 3;
    public static final int CODE_BINARY = 4;
    public static final int CODE_ASCII_NIBBLE = 5;
    private static final String CODE_EBCDIC_TEXT = "Cp500";
    private static final String CODE_BCD_TEXT = "Cp500";
    private static final String CODE_ASCII_TEXT = "8859_1";
    private static final String CODE_BINARY_TEXT = "Binary";
    private static final String CODE_ASCII_NIBBLE_TEXT = "ASCII";
    private static final int DATA_BLOCK = 256;

    public String decode(String EncodedText, int TextCode) {
        if (EncodedText == null || !this.supportsCode(TextCode)) {
            return null;
        }
        if (TextCode == 3 || TextCode == 5) {
            return EncodedText;
        }
        String decodedText = null;
        decodedText = TextCode == 4 ? this.readBinaryCode(EncodedText) : this.readNormalCodec(EncodedText, TextDecoder.getCodecText(TextCode));
        return decodedText;
    }

    public String decode(byte[] encodedBytes, int TextCode) {
        if (encodedBytes == null || !this.supportsCode(TextCode)) {
            return null;
        }
        if (TextCode == 3 || TextCode == 5) {
            return new String(encodedBytes);
        }
        String decodedText = null;
        decodedText = TextCode == 4 ? HexaDecimal.parse(encodedBytes) : this.readNormalCodec(encodedBytes, TextDecoder.getCodecText(TextCode));
        return decodedText;
    }

    public String decode(File EncodedTextFile, int TextCode) {
        if (EncodedTextFile == null || !this.supportsCode(TextCode)) {
            return null;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(EncodedTextFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        StreamReader reader = new StreamReader(fin);
        String fileData = null;
        try {
            fileData = reader.read();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (fileData != null) {
            return this.decode(fileData, TextCode);
        }
        return null;
    }

    private String readBinaryCode(String EncodedText) {
        return HexaDecimal.parse(EncodedText);
    }

    private String readNormalCodec(String EncodedText, String TextCodec) {
        return this.readNormalCodec(EncodedText.getBytes(), TextCodec);
    }

    private String readNormalCodec(byte[] encodedByte, String TextCodec) {
        String decodedText = null;
        try {
            decodedText = new String(encodedByte, TextCodec);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return decodedText;
    }

    public static String getCodecText(int textCode) {
        String resultedCodecText = null;
        switch (textCode) {
            case 1: 
            case 2: {
                resultedCodecText = "Cp500";
                break;
            }
            case 3: 
            case 5: {
                resultedCodecText = CODE_ASCII_TEXT;
                break;
            }
            case 4: {
                resultedCodecText = CODE_BINARY_TEXT;
            }
        }
        return resultedCodecText;
    }

    public boolean supportsCode(int codeSupported) {
        return codeSupported >= 1 || codeSupported <= 5;
    }
}

