/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.transaction.util;

import org.smyld.SMYLDObject;
import org.smyld.text.TextUtil;

public class TransUtility
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_KEEP_DIGITS = 9;
    public static final int MIN_KEEP_DIGITS = 4;
    public static final int MAX_KEEP_DIGITS = 16;

    public static String scrambleCardNo(String sourceCardNo, int keepDigits) {
        return TransUtility.scrambleCardNo(sourceCardNo, keepDigits, -1L);
    }

    public static String scrambleCardNo(String sourceCardNo, int keepDigits, long fakeNumber) {
        if (sourceCardNo.length() < keepDigits) {
            return sourceCardNo;
        }
        String resultantCard = sourceCardNo.substring(0, keepDigits);
        if (fakeNumber != -1L) {
            resultantCard = resultantCard + Long.toString(fakeNumber);
        } else {
            int fakeNumberWidth = sourceCardNo.length() - keepDigits - 1;
            StringBuffer buffer = new StringBuffer();
            String newNumber = Long.toString(System.currentTimeMillis());
            if (newNumber.length() > fakeNumberWidth) {
                buffer.append(newNumber.substring(newNumber.length() - fakeNumberWidth));
            }
            resultantCard = resultantCard + buffer.toString();
        }
        String resultCardNum = TransUtility.generateValidCardNo(resultantCard);
        if (resultCardNum.equals(sourceCardNo)) {
            resultCardNum = TransUtility.scrambleCardNo(sourceCardNo, keepDigits, fakeNumber);
        }
        return resultCardNum;
    }

    public static String generateValidCardNo(String cardNo) {
        int luhnDigit = TransUtility.generateLUHN(cardNo);
        cardNo = cardNo + Integer.toString(luhnDigit);
        return cardNo;
    }

    public static String scrambleCardNoWithKey(String sourceCardNo, int keepDigits, long keyValue) {
        if (sourceCardNo.length() < keepDigits) {
            return sourceCardNo;
        }
        if (keepDigits <= 4 || keepDigits > 16) {
            keepDigits = 9;
        }
        StringBuffer buffer = new StringBuffer();
        String resultantCard = sourceCardNo.substring(0, keepDigits);
        buffer.append(resultantCard);
        if (keyValue != -1L) {
            String keyText = Long.toString(keyValue);
            int keyLength = keyText.length();
            int scrNumWidth = sourceCardNo.length() - keepDigits - 1;
            long originalValue = Long.parseLong(sourceCardNo.substring(keepDigits, keepDigits + scrNumWidth));
            if (scrNumWidth < keyLength) {
                keyValue = Long.parseLong(keyText.substring(keyLength - scrNumWidth));
            }
            long resultValue = originalValue ^ keyValue;
            buffer.append(TextUtil.fillLeftSide(resultValue, scrNumWidth, '9'));
        }
        String resultCardNum = TransUtility.generateValidCardNo(buffer.toString());
        return resultCardNum;
    }

    public static int generateLUHN(String cardNo) {
        int result = 0;
        boolean odd = true;
        for (int i = cardNo.length() - 1; i >= 0; --i) {
            int curNo = Integer.parseInt(cardNo.substring(i, i + 1));
            if (odd && (curNo *= 2) > 8) {
                curNo -= 9;
            }
            odd = !odd;
            result += curNo;
        }
        if (result % 10 == 0) {
            return 0;
        }
        return 10 - result % 10;
    }

    public static boolean validateLuhn(String cardNo) {
        int checkDigit;
        if (cardNo == null || !TextUtil.isNumeric(cardNo)) {
            return false;
        }
        int luhnDigit = TransUtility.generateLUHN(cardNo.substring(0, cardNo.length() - 1));
        return luhnDigit == (checkDigit = Integer.parseInt(cardNo.substring(cardNo.length() - 1)));
    }
}

