/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import org.smyld.SMYLDObject;
import org.smyld.xml.XMLConstants;

public class XMLSimpleWriter
extends SMYLDObject
implements XMLConstants {
    private static final long serialVersionUID = 1L;
    FileOutputStream fout;

    public void createFile(String fileName) throws IOException {
        this.fout = new FileOutputStream(fileName);
    }

    public void AddTag(String tagName) {
    }

    public void addTag(String tagName, String[][] attributes, String tagValue) throws Exception {
        StringBuffer buffer = new StringBuffer(this.getTagOpen(tagName));
        this.addAttributes(buffer, attributes);
        buffer.append(" >");
        buffer.append(tagValue);
        buffer.append(this.getTagFullClose(tagName));
        this.addText(buffer.toString());
    }

    public void addTag(String tagName, String[][] attributes) throws Exception {
        StringBuffer buffer = new StringBuffer(this.getTagOpen(tagName));
        this.addAttributes(buffer, attributes);
        buffer.append(" />");
        this.addText(buffer.toString());
    }

    public void addTag(String tagName, String tagValue) throws Exception {
        StringBuffer buffer = new StringBuffer(this.getTagFullOpen(tagName));
        buffer.append(tagValue);
        buffer.append(this.getTagFullClose(tagName));
        this.addText(buffer.toString());
    }

    private String getTagOpen(String tagName) {
        return "<" + tagName;
    }

    private String getTagFullOpen(String tagName) {
        return "<" + tagName + ">";
    }

    private String getTagFullClose(String tagName) {
        return "</" + tagName + ">";
    }

    private void addAttributes(StringBuffer buffer, String[][] attributes) {
        for (int i = 0; i < attributes[0].length; ++i) {
            buffer.append(" ");
            buffer.append(attributes[0][i]);
            buffer.append("=\"");
            buffer.append(attributes[1][i]);
            buffer.append("\"");
        }
    }

    public void addTagStart(String tagName) throws Exception {
        this.addText(this.getTagOpen(tagName));
    }

    public void addTagFullStart(String tagName) throws Exception {
        this.addText(this.getTagFullOpen(tagName));
    }

    public void addTagEnd(String tagName) throws Exception {
        this.addText(this.getTagFullClose(tagName));
    }

    public void addEncodingHeader(String encodingName) throws Exception {
        this.addText("<?xml version='1.0' encoding=\"" + encodingName + "\"?>");
    }

    public void addXSLHeader(String xslFileName) throws Exception {
        this.addText("<?xml-stylesheet type=\"text/xsl\" href=\"" + xslFileName + "\"?>");
    }

    private void addText(String newText) throws Exception {
        this.fout.write((newText + OS_NEW_LINE).getBytes());
    }
}

