/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.deploy.web;

import java.util.HashMap;
import org.jdom2.Content;
import org.jdom2.Element;
import org.smyld.deploy.web.MIMEDescriptor;
import org.smyld.deploy.web.WebDescConstants;
import org.smyld.xml.XMLFileWriter;

public class WebFileWriter
extends XMLFileWriter
implements WebDescConstants {
    private static final long serialVersionUID = 1L;
    String description;
    int sessionTimeOut;
    HashMap<String, MIMEDescriptor> mimeMappings;

    public WebFileWriter() {
        this.init();
    }

    private void init() {
        this.rootElement = new Element("web-app");
        this.addMIMEMapping(new MIMEDescriptor("text/html", "html"));
        this.addMIMEMapping(new MIMEDescriptor("text/plain", "txt"));
    }

    @Override
    protected void compose() {
        Element desc = new Element("description");
        if (this.getDescription() != null) {
            desc.setText(this.getDescription());
        } else {
            desc.setText("Empty web.xml file for Web Application");
        }
        this.rootElement.addContent((Content)desc);
        if (this.getSessionTimeOut() != 0) {
            Element sesConfig = new Element("session-config");
            Element sesTimeOut = new Element("session-timeout");
            sesTimeOut.setText(Integer.toString(this.getSessionTimeOut()));
            sesConfig.addContent((Content)sesTimeOut);
            this.rootElement.addContent((Content)sesConfig);
        }
        for (MIMEDescriptor curMapping : this.mimeMappings.values()) {
            this.rootElement.addContent((Content)curMapping.getXMLElement());
        }
    }

    public void addJNLPMappings() {
        this.addMIMEMapping(new MIMEDescriptor("application/x-java-jnlp-file", "jnlp"));
    }

    public void addMIMEMapping(MIMEDescriptor newMapping) {
        if (this.mimeMappings == null) {
            this.mimeMappings = new HashMap();
        }
        this.mimeMappings.put(newMapping.getExtension(), newMapping);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    public void setSessionTimeOut(int sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
    }

    public HashMap<String, MIMEDescriptor> getMimeMappings() {
        return this.mimeMappings;
    }

    public void setMimeMappings(HashMap<String, MIMEDescriptor> mimeMappings) {
        this.mimeMappings = mimeMappings;
    }

    @Override
    public String getFileName() {
        if (this.fileName == null) {
            return "web.xml";
        }
        return this.fileName;
    }
}

