/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import org.smyld.io.StreamListener;

public class SMYLDInputStream
extends BufferedInputStream
implements Runnable {
    boolean stopListen = false;
    int blockSize = 256;
    long sleepTime = 5L;
    StringBuffer buffer = new StringBuffer();
    byte[] data;
    StreamListener listenerClass;
    Thread activeThread;
    public static final int DEFAULT_BLOCK_SIZE = 256;
    public static final int DEFAULT_SLEEP_TIME = 5;

    public SMYLDInputStream(InputStream inputStream) {
        super(inputStream);
        this.data = new byte[this.blockSize];
    }

    public SMYLDInputStream(InputStream inputStream, int BlockSize) {
        super(inputStream, BlockSize);
        this.setBlockSize(BlockSize);
        this.data = new byte[this.blockSize];
    }

    public SMYLDInputStream(InputStream inputStream, int BlockSize, long SleepTime) {
        this(inputStream, BlockSize);
        this.sleepTime = SleepTime;
    }

    @Override
    public int read() {
        return -1;
    }

    @Override
    public void run() {
        while (!this.stopListen) {
            int dataSize = 0;
            this.buffer.setLength(0);
            try {
                while ((dataSize = this.available()) != 0) {
                    this.data = new byte[dataSize];
                    this.read(this.data);
                    this.buffer.append(new String(this.data));
                }
                if (this.buffer.length() > 0) {
                    this.listenerClass.dataReceived(this.buffer.toString().getBytes());
                    this.listenerClass.textRecieved(this.buffer.toString());
                }
                Thread.sleep(this.sleepTime);
            }
            catch (SocketException soc) {
                try {
                    this.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void addStreamListener(StreamListener ListenerClass) {
        this.listenerClass = ListenerClass;
    }

    public void stop() {
        this.stopListen = true;
    }

    public void resume() {
        this.stopListen = false;
    }

    @Override
    public void close() throws IOException {
        this.stop();
        super.close();
    }

    public void setBlockSize(int readingBlockSize) {
        if (readingBlockSize > 0) {
            this.blockSize = readingBlockSize;
            this.data = new byte[this.blockSize];
        }
    }
}

