/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.io;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.smyld.SMYLDObject;

public class StreamReader
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    InputStream inputStream;
    Reader reader;
    private static final int DATA_BLOCK = 256;

    public StreamReader() {
    }

    public StreamReader(String inputFileName) throws IOException {
        this.inputStream = new FileInputStream(inputFileName);
    }

    public StreamReader(File inputFile) throws IOException {
        this.inputStream = new FileInputStream(inputFile);
    }

    public StreamReader(InputStream inputStreamObject) {
        this.inputStream = inputStreamObject;
    }

    public StreamReader(Reader readerObject) {
        this.reader = readerObject;
    }

    public String read() throws IOException {
        if (this.inputStream != null) {
            return this.readInputStream();
        }
        if (this.reader != null) {
            return this.readReader();
        }
        return null;
    }

    public String read(int dataBlockAmount) {
        if (this.inputStream != null) {
            return this.readInputStream(dataBlockAmount);
        }
        if (this.reader != null) {
            return this.readReader(dataBlockAmount);
        }
        return null;
    }

    private String readInputStream() throws IOException {
        StringBuffer readText = new StringBuffer();
        byte[] resultData = new byte[256];
        int realAmountRead = 0;
        while ((realAmountRead = this.inputStream.read(resultData)) != -1) {
            readText.append(this.readRealInfo(realAmountRead, resultData));
        }
        return readText.toString();
    }

    private String readInputStream(int dataBlock) {
        String readText = null;
        byte[] resultData = new byte[dataBlock];
        int realAmountRead = 0;
        try {
            realAmountRead = this.inputStream.read(resultData);
            if (realAmountRead != -1) {
                readText = this.readRealInfo(realAmountRead, resultData);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return readText;
    }

    private String readRealInfo(int realAmountRead, byte[] dataArray) throws IOException {
        if (realAmountRead < dataArray.length) {
            ByteArrayInputStream byteArrayReader = new ByteArrayInputStream(dataArray, 0, realAmountRead);
            byte[] finalData = new byte[realAmountRead];
            byteArrayReader.read(finalData);
            return new String(finalData);
        }
        return new String(dataArray);
    }

    private String readRealInfo(int realAmountRead, char[] dataArray) throws IOException {
        if (realAmountRead < dataArray.length) {
            CharArrayReader charArrayReader = new CharArrayReader(dataArray, 0, realAmountRead);
            char[] finalData = new char[realAmountRead];
            charArrayReader.read(finalData);
            return new String(finalData);
        }
        return new String(dataArray);
    }

    private String readReader() {
        StringBuffer readText = new StringBuffer();
        char[] resultData = new char[256];
        int realAmountRead = 0;
        try {
            while ((realAmountRead = this.reader.read(resultData)) != -1) {
                readText.append(this.readRealInfo(realAmountRead, resultData));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return readText.toString();
    }

    private String readReader(int dataBlock) {
        StringBuffer readText = new StringBuffer();
        char[] resultData = new char[dataBlock];
        int realAmountRead = 0;
        try {
            realAmountRead = this.reader.read(resultData);
            readText.append(this.readRealInfo(realAmountRead, resultData));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return readText.toString();
    }
}

