/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.run;

import java.io.IOException;
import java.io.OutputStreamWriter;
import org.smyld.SMYLDObject;
import org.smyld.io.SMYLDInputStream;
import org.smyld.io.StreamAdapter;
import org.smyld.run.RunProcessListener;

public class SMYLDRunProcess
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    Process curProcess;
    SMYLDInputStream errStr;
    SMYLDInputStream resStr;
    OutputStreamWriter outStr;
    RunProcessListener activeListener;

    public SMYLDRunProcess() {
    }

    public SMYLDRunProcess(Process runProcess) {
        this.handleProcess(runProcess);
    }

    public SMYLDRunProcess(Process runProcess, RunProcessListener newListener) {
        this.activeListener = newListener;
        this.handleProcess(runProcess);
    }

    public void handleProcess(Process runProcess) {
        this.curProcess = runProcess;
        this.errStr = new SMYLDInputStream(this.curProcess.getErrorStream(), 1024, 500L);
        this.resStr = new SMYLDInputStream(this.curProcess.getInputStream(), 1024, 500L);
        this.outStr = new OutputStreamWriter(this.curProcess.getOutputStream());
        this.errStr.addStreamListener(new StreamAdapter(){
            private static final long serialVersionUID = 1L;

            @Override
            public void textRecieved(String newText) {
                if (SMYLDRunProcess.this.activeListener != null) {
                    SMYLDRunProcess.this.activeListener.onError(newText);
                }
            }
        });
        this.resStr.addStreamListener(new StreamAdapter(){
            private static final long serialVersionUID = 1L;

            @Override
            public void textRecieved(String newText) {
                if (SMYLDRunProcess.this.activeListener != null) {
                    SMYLDRunProcess.this.activeListener.onResponse(newText);
                }
            }
        });
        new Thread(this.errStr).start();
        new Thread(this.resStr).start();
    }

    public void addProcessListener(RunProcessListener newListener) {
        this.activeListener = newListener;
    }

    public void close() {
        try {
            this.errStr.close();
            this.resStr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void send(String text) throws IOException {
        if (this.outStr != null) {
            this.outStr.write(text);
            this.outStr.flush();
        }
    }
}

