/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.security;

import java.util.HashMap;
import org.smyld.text.TextTokenizer;

public class SMYLDIPFilter {
    HashMap<String, String> allowedIPs;
    String subNetMask;
    private static final int IP_VALID_WIDTH = 15;

    public SMYLDIPFilter(HashMap<String, String> AllowedIPs) {
        this.allowedIPs = AllowedIPs;
    }

    public SMYLDIPFilter(String[] AllowedIPs) {
        this.setAllowedIPs(AllowedIPs);
    }

    public SMYLDIPFilter(String[] AllowedIPs, String SubNetMask) {
        this(AllowedIPs);
        this.setSubNetMask(SubNetMask);
    }

    public boolean isAllowed(String IP) {
        if (!this.allowedIPs.containsKey(IP)) {
            if (this.subNetMask != null) {
                return IP.startsWith(this.subNetMask);
            }
            return false;
        }
        return true;
    }

    public String getSubNetMask() {
        return this.subNetMask;
    }

    public void setAllowedIPs(HashMap<String, String> newIPRange) {
        this.allowedIPs = newIPRange;
    }

    public void setAllowedIPs(String[] ipArray) {
        if (this.allowedIPs == null) {
            this.allowedIPs = new HashMap();
        } else {
            this.allowedIPs.clear();
        }
        for (int i = 0; i < ipArray.length; ++i) {
            this.allowedIPs.put(ipArray[i], ipArray[i]);
        }
    }

    public HashMap<String, String> getAllowedIPs() {
        return this.allowedIPs;
    }

    public void setSubNetMask(String newSubNetMask) {
        if (newSubNetMask != null && SMYLDIPFilter.isValidIP(newSubNetMask = newSubNetMask.toLowerCase().replace('x', '0'))) {
            this.subNetMask = newSubNetMask.substring(0, newSubNetMask.lastIndexOf("."));
        }
    }

    public static boolean isValidIP(String IPAddress) {
        TextTokenizer stringTockens;
        String[] IPParts;
        if (IPAddress != null && IPAddress.length() <= 15 && (IPParts = (stringTockens = new TextTokenizer(IPAddress, ".")).parseTokens()).length == 4) {
            for (int i = 0; i < IPParts.length; ++i) {
                try {
                    if (Integer.parseInt(IPParts[i]) <= 255) continue;
                    return false;
                }
                catch (Exception ex) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

