/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.text;

import org.smyld.SMYLDObject;
import org.smyld.text.WordFilterProcessor;

public class WordFilter
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    String specialCharacters;
    String filterCharacters;
    StringBuffer buffer = new StringBuffer();
    WordFilterProcessor addProcessor;
    public static final String Default_SPECIAL_CHAR_SET = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0722\ufffd\ufffd\ufffd\ufffd\ufffd\u046a\ufffd";
    public static final String Default_FILTER_CHAR_SET = "CueaaaaceeeiiiAAEaAooouuuyyOUcaiounNao";

    public WordFilter(boolean supportDefault) {
        this.doInit(Default_SPECIAL_CHAR_SET, Default_FILTER_CHAR_SET, null, supportDefault);
    }

    public WordFilter(String SpecialCharacterSet, String FilterCharacterSet, boolean supportDefault) {
        this.doInit(SpecialCharacterSet, FilterCharacterSet, null, supportDefault);
    }

    public WordFilter(String SpecialCharacterSet, String FilterCharacterSet, WordFilterProcessor newProcessor) {
        this.doInit(SpecialCharacterSet, FilterCharacterSet, newProcessor, false);
    }

    private void doInit(String specialSet, String filterSet, WordFilterProcessor wordProcessor, boolean supportDefault) {
        this.specialCharacters = specialSet;
        this.filterCharacters = filterSet;
        if (wordProcessor != null) {
            this.addProcessor = wordProcessor;
        } else if (supportDefault) {
            this.addProcessor = new WordFilterProcessor(){

                @Override
                public boolean filterChar(char wordChar) {
                    return WordFilter.this.doDefaultFiltering(wordChar);
                }
            };
        }
    }

    public boolean doDefaultFiltering(char filterChar) {
        return filterChar >= '~' || filterChar < ' ' || filterChar == '`' || filterChar > 'Z' && filterChar < '_';
    }

    public String doFilter(String word) {
        this.buffer.setLength(0);
        for (int i = 0; i < word.length(); ++i) {
            int currentChar = word.charAt(i);
            int charIndex = this.specialCharacters.indexOf(currentChar);
            if (charIndex != -1) {
                currentChar = this.filterCharacters.charAt(charIndex);
            } else if (this.addProcessor != null) {
                if (this.addProcessor.filterChar((char)currentChar)) {
                    currentChar = 32;
                }
            } else if (!Character.isLetterOrDigit((char)currentChar)) {
                currentChar = 32;
            }
            this.buffer.append((char)currentChar);
        }
        return this.buffer.toString();
    }

    public boolean containsInvalidCharacters(String word) {
        for (int i = 0; i < word.length(); ++i) {
            char currentChar = word.charAt(i);
            int charIndex = this.specialCharacters.indexOf(currentChar);
            if (charIndex != -1) {
                currentChar = this.filterCharacters.charAt(charIndex);
                continue;
            }
            if (!(this.addProcessor != null ? this.addProcessor.filterChar(currentChar) : !Character.isLetterOrDigit(currentChar))) continue;
            return true;
        }
        return false;
    }
}

