/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util.vmapper;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.smyld.SMYLDObject;
import org.smyld.resources.Resource;
import org.smyld.text.TextUtil;
import org.smyld.util.IntValueMapper;
import org.smyld.util.ValueMapper;
import org.smyld.util.vmapper.VMapperConstants;
import org.smyld.xml.XMLUtil;

public class ValueMappersFactory
extends SMYLDObject
implements VMapperConstants {
    private static final long serialVersionUID = 1L;
    Element root;
    String mappName;

    public ValueMapper Build(String SourceXMLFileName, String mappingName) throws Exception {
        InputStream fileStream = new Resource().getResourceInputStream(SourceXMLFileName);
        this.root = new SAXBuilder().build(fileStream).getRootElement();
        this.mappName = mappingName;
        return this.buildFromXML();
    }

    public ValueMapper Build(Connection conn, String tableName, String srcFieldName, String destFieldName) throws Exception {
        String sqlQuery = "Select * from " + tableName;
        PreparedStatement pst = conn.prepareStatement(sqlQuery);
        ResultSet rs = pst.executeQuery();
        ValueMapper mapper = null;
        while (rs.next()) {
            if (mapper == null) {
                mapper = new ValueMapper();
            }
            String keyValue = rs.getString(srcFieldName);
            String value = rs.getString(destFieldName);
            if (TextUtil.isEmpty(keyValue)) continue;
            mapper.addKey(null, keyValue, value);
        }
        return mapper;
    }

    public ValueMapper Build(File ExternalXMLFile, String mappingName) throws Exception {
        this.root = new SAXBuilder().build(ExternalXMLFile).getRootElement();
        this.mappName = mappingName;
        return this.buildFromXML();
    }

    private ValueMapper buildFromXML() {
        List mappingList = this.root.getChildren("mapping");
        Element targetMap = this.getMapper(mappingList);
        if (targetMap != null) {
            return this.buildSingleMapFromNode(targetMap, null);
        }
        return null;
    }

    public IntValueMapper BuildIntMapper(String SourceXMLFileName, String mappingName) throws Exception {
        InputStream fileStream = new Resource().getResourceInputStream(SourceXMLFileName);
        this.root = new SAXBuilder().build(fileStream).getRootElement();
        this.mappName = mappingName;
        return this.buildIntFromXML();
    }

    public IntValueMapper BuildIntMapper(File ExternalXMLFile, String mappingName) throws Exception {
        this.root = new SAXBuilder().build(ExternalXMLFile).getRootElement();
        this.mappName = mappingName;
        return this.buildIntFromXML();
    }

    private IntValueMapper buildIntFromXML() {
        List mappingList = this.root.getChildren("mapping");
        Element targetMap = this.getMapper(mappingList);
        if (targetMap != null) {
            return this.buildSingleIntMapFromNode(targetMap, null);
        }
        return null;
    }

    private IntValueMapper buildSingleIntMapFromNode(Element parentNode, IntValueMapper mapper) {
        if (mapper == null) {
            mapper = new IntValueMapper();
        }
        List children = parentNode.getChildren("map");
        for (Element curNode : children) {
            String curKey = curNode.getAttributeValue("key");
            if (XMLUtil.hasChildren(curNode)) {
                IntValueMapper childMapper = new IntValueMapper();
                mapper.addKey(curKey, (Object)childMapper);
                this.buildSingleIntMapFromNode(curNode, childMapper);
                continue;
            }
            String curValue = curNode.getAttributeValue("value");
            mapper.addKey(curKey, (Object)curValue);
        }
        return mapper;
    }

    private ValueMapper buildSingleMapFromNode(Element parentNode, ValueMapper mapper) {
        if (mapper == null) {
            mapper = new ValueMapper();
        }
        List children = parentNode.getChildren("map");
        for (Element curNode : children) {
            String curKey = curNode.getAttributeValue("key");
            if (XMLUtil.hasChildren(curNode)) {
                ValueMapper childMapper = mapper.addMappingKey(null, curKey);
                this.buildSingleMapFromNode(curNode, childMapper);
                continue;
            }
            String curValue = curNode.getAttributeValue("value");
            mapper.addKey(null, curKey, curValue);
        }
        return mapper;
    }

    private Element getMapper(List nodes) {
        for (Element curNode : nodes) {
            String mapID = curNode.getAttributeValue("id");
            if (mapID == null || !mapID.equals(this.mappName)) continue;
            return curNode;
        }
        return null;
    }
}

