/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.deploy.web.jnlp;

import java.util.Vector;
import org.jdom2.Content;
import org.jdom2.Element;
import org.smyld.deploy.web.jnlp.AppDescriptor;
import org.smyld.deploy.web.jnlp.InfoDescriptor;
import org.smyld.deploy.web.jnlp.JARDescriptor;
import org.smyld.deploy.web.jnlp.JNLPConstants;
import org.smyld.deploy.web.jnlp.JNLPDeploymentDescriptor;
import org.smyld.deploy.web.jnlp.ResourceDescriptor;
import org.smyld.deploy.web.jnlp.SecurityDescriptor;
import org.smyld.deploy.web.jnlp.ShortcutDescriptor;
import org.smyld.xml.XMLFileWriter;

public class JNLPFileWriter
extends XMLFileWriter
implements JNLPConstants {
    private static final long serialVersionUID = 1L;
    String codeBase;
    String name;
    String mainJarFile;
    Vector<ResourceDescriptor> resources;
    Vector<AppDescriptor> applications;
    Vector<InfoDescriptor> infoDescriptors;
    InfoDescriptor defInfo;
    AppDescriptor defApp;
    ResourceDescriptor defRes;
    SecurityDescriptor defSec;

    public JNLPFileWriter() {
        this.init();
    }

    private void init() {
        this.rootElement = new Element("jnlp");
        this.rootElement.setAttribute("spec", "1.0+");
        this.defInfo = new InfoDescriptor();
        this.defApp = new AppDescriptor();
        this.defRes = new ResourceDescriptor();
        this.defSec = new SecurityDescriptor();
    }

    @Override
    protected void compose() {
        this.rootElement.setAttribute("codebase", this.getCodeBase());
        this.rootElement.setAttribute("href", this.getName());
        this.rootElement.addContent((Content)this.defInfo.getXMLElement());
        this.rootElement.addContent((Content)this.defRes.getXMLElement());
        this.rootElement.addContent((Content)this.defApp.getXMLElement());
        this.rootElement.addContent((Content)this.defSec.getXMLElement());
    }

    public String getCodeBase() {
        if (this.codeBase == null) {
            return ".";
        }
        return this.codeBase;
    }

    public void setCodeBase(String codeBase) {
        this.codeBase = codeBase;
    }

    public String getMainJarFile() {
        return this.mainJarFile;
    }

    public void setMainJarFile(String MainJarFile) {
        this.mainJarFile = MainJarFile;
    }

    public String getName() {
        if (this.name == null) {
            return "app.jnlp";
        }
        if (!this.name.endsWith(".jnlp")) {
            return this.name + ".jnlp";
        }
        return this.name;
    }

    public void grantAllPermissions() {
        this.defSec.addAllPermissions();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.defInfo.getTitle();
    }

    public void setTitle(String title) {
        this.defInfo.setTitle(title);
    }

    public String getVendor() {
        return this.defInfo.getVendor();
    }

    public void setVendor(String vendor) {
        this.defInfo.setVendor(vendor);
    }

    public String getHomePage() {
        return this.defInfo.getHomePage();
    }

    public void setHomePage(String homePage) {
        this.defInfo.setHomePage(homePage);
    }

    public String getDescription() {
        return this.defInfo.getDescription();
    }

    public void setDescription(String description) {
        this.defInfo.setDescription(description);
    }

    public String getJ2seVersion() {
        return this.defRes.getJ2seVersion();
    }

    public void setJ2seVersion(String j2seVersion) {
        this.defRes.setJ2seVersion(j2seVersion);
    }

    public Vector<ResourceDescriptor> getResources() {
        return this.resources;
    }

    public Vector<AppDescriptor> getApplications() {
        return this.applications;
    }

    public void addInfoDescriptor(InfoDescriptor newInfo) {
        if (this.infoDescriptors == null) {
            this.infoDescriptors = new Vector();
        }
        this.infoDescriptors.add(newInfo);
    }

    public void addAppDescriptor(AppDescriptor newApp) {
        if (this.applications == null) {
            this.applications = new Vector();
        }
        this.applications.add(newApp);
    }

    public void addInfoDescriptor(ResourceDescriptor newRes) {
        if (this.resources == null) {
            this.resources = new Vector();
        }
        this.resources.add(newRes);
    }

    public void addJarFile(String JarName) {
        this.addJarFile(JarName, false, "eager");
    }

    public void addJarFile(String JarName, boolean withMainClass) {
        this.addJarFile(JarName, withMainClass, "eager");
        if (withMainClass) {
            this.setMainJarFile(JarName);
        }
    }

    public void addJarFile(String JarName, String downloadType) {
        this.addJarFile(JarName, false, downloadType);
    }

    public void addJarFile(String JarName, boolean withMainClass, String downloadType) {
        JARDescriptor newJar = new JARDescriptor();
        newJar.setContainsMain(withMainClass);
        newJar.setRef(JarName);
        newJar.setDownloadType(downloadType);
        this.defRes.addJAR(newJar);
    }

    public Vector<InfoDescriptor> getInfoDescriptors() {
        return this.infoDescriptors;
    }

    public String getMainClass() {
        return this.defApp.getMainClass();
    }

    public void setMainClass(String mainClass) {
        this.defApp.setMainClass(mainClass);
    }

    public String getTooltip() {
        return this.defInfo.getTooltip();
    }

    public void setTooltip(String tooltip) {
        this.defInfo.setTooltip(tooltip);
    }

    public void addShortCut(boolean firesApplicationOnline, boolean creatInDesktop, String menuTitle) {
        ShortcutDescriptor newShort = new ShortcutDescriptor();
        newShort.setDesktop(creatInDesktop);
        newShort.setOnline(firesApplicationOnline);
        newShort.setMenu(menuTitle);
        this.defInfo.setShortCut(newShort);
    }

    public String getIcon() {
        return this.defInfo.getIcon();
    }

    public void setIcon(String icon) {
        this.defInfo.setIcon(icon);
    }

    public boolean isOfflineAllowed() {
        return this.defInfo.isOfflineAllowed();
    }

    public void setOfflineAllowed(boolean offlineAllowed) {
        this.defInfo.setOfflineAllowed(offlineAllowed);
    }

    public void importDescriptor(JNLPDeploymentDescriptor desc) {
        this.setCodeBase(desc.getCodeBase());
        this.setDescription(desc.getDescription());
        this.setIcon(desc.getIcon());
        this.setName(desc.getName());
        this.setOfflineAllowed(desc.isOfflineAllowed());
        this.setTitle(desc.getTitle());
        this.setTooltip(desc.getTooltip());
        this.setVendor(desc.getVendor());
        this.setMainClass(desc.getMainClass());
        if (desc.getShortcut() != null) {
            this.defInfo.setShortCut(desc.getShortcut());
        }
    }
}

