/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.log;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.smyld.log.AbstractLogManager;
import org.smyld.log.LogManager;
import org.smyld.log.LogRecord;

public class DefaultLogManager
extends AbstractLogManager
implements LogManager {
    private static final long serialVersionUID = 1L;
    private HashMap<String, LogRecord> records = new HashMap();
    private static int seqKey = -1;

    @Override
    public void addRecord(LogRecord record) {
        this.records.put("" + ++seqKey, record);
    }

    @Override
    public Collection<LogRecord> getRecords() {
        return this.records.values();
    }

    @Override
    public LogRecord fetchRecord(Object ob) {
        if (!this.records.containsKey(ob)) {
            return null;
        }
        LogRecord lrec = this.records.get(ob);
        return lrec;
    }

    @Override
    public void writeReports(String filepath) {
        StringBuffer str = new StringBuffer();
        str.append("Class name\t Module name\t Message\t Start time\t End time\n");
        int size = this.records.size();
        for (int i = 0; i < size; ++i) {
            LogRecord rec = this.records.get("" + i);
            str.append(rec.toString());
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filepath));
            out.write(str.toString());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void closeLog() throws IOException {
    }
}

