/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.net.url;

import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.smyld.net.url.URLConnector;

public class HTTPURLConnector
extends URLConnector {
    private static final long serialVersionUID = 1L;
    HttpURLConnection httpConnection;
    HashMap<String, String> requestParams;
    StringBuffer buffer = new StringBuffer();
    String targetAddress;

    public HTTPURLConnector(URL targetURL) {
        super(targetURL);
        this.targetAddress = targetURL.toExternalForm();
        this.requestParams = new HashMap();
    }

    public boolean sendHttpRequest() {
        try {
            this.buffer.setLength(0);
            this.buffer.append(this.targetAddress);
            if (this.requestParams.size() > 0) {
                this.addRequestParams(this.buffer);
            }
            this.serverURL = new URL(this.buffer.toString());
            this.httpConnection = (HttpURLConnection)this.serverURL.openConnection();
            return this.httpConnection.getResponseCode() == 200;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void addRequestParams(StringBuffer resultBuffer) {
        resultBuffer.append("?");
        Iterator<String> itr = this.requestParams.keySet().iterator();
        while (itr.hasNext()) {
            String currentKey = itr.next();
            resultBuffer.append(currentKey);
            resultBuffer.append("=");
            resultBuffer.append(this.requestParams.get(currentKey));
            if (!itr.hasNext()) continue;
            resultBuffer.append("&");
        }
    }

    public void setRequestMethod(String methodName) throws ProtocolException {
        this.httpConnection.setRequestMethod(methodName);
    }

    public void setRequestParameter(String paramName, String paramValue) {
        this.requestParams.put(paramName, paramValue);
    }
}

