/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.text;

import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import org.smyld.SMYLDObject;
import org.smyld.io.FileSystem;

public class TextUtil
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    private static int lastPosition = 0;
    public static final String SPECIAL_CHAR_SET = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0722\ufffd\ufffd\ufffd\ufffd\ufffd\u046a\ufffd\ufffd`'.";
    public static final String FILTER_CHAR_SET = "CueaaaaceeeiiiAAEaAooouuuyyOUcaiounNao    ";

    public static synchronized String toTitleCase(String textToChange) {
        String firstLetter = textToChange.substring(0, 1);
        firstLetter = firstLetter.toUpperCase();
        return firstLetter + textToChange.substring(1);
    }

    public static synchronized String createWord(char fillingChar, int width) {
        char[] wordChars = new char[width];
        for (int i = 0; i < width; ++i) {
            wordChars[i] = fillingChar;
        }
        return new String(wordChars);
    }

    public static synchronized String createWord(String fillingText, int iterationNo) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < iterationNo; ++i) {
            buffer.append(fillingText);
        }
        return buffer.toString();
    }

    public static synchronized String resize(String value, int width) {
        value = !TextUtil.isEmpty(value) ? (value.length() > width ? (value.trim().length() > width ? value.trim().substring(0, width) : TextUtil.fillRightSide(value.trim(), width, ' ')) : TextUtil.fillRightSide(value, width, ' ')) : TextUtil.createWord(' ', width);
        return value;
    }

    public static synchronized String right(String value, int digitsNumber) {
        if (!TextUtil.isEmpty(value) && value.length() > digitsNumber) {
            return value.substring(value.length() - digitsNumber);
        }
        return value;
    }

    public static synchronized String left(String value, int digitsNumber) {
        if (!TextUtil.isEmpty(value) && value.length() > digitsNumber) {
            return value.substring(0, digitsNumber);
        }
        return value;
    }

    public static synchronized boolean isEmpty(String value) {
        return value == null || value.trim().length() <= 0;
    }

    public static synchronized boolean within(String value, String range) {
        if (TextUtil.isEmpty(value)) {
            return false;
        }
        return range.indexOf(value) != -1;
    }

    public static synchronized String fillLeftSideWithSpaces(String value, int width) {
        return TextUtil.fillText(value, width, ' ', true);
    }

    public static synchronized String fillRightSideWithSpaces(String value, int width) {
        return TextUtil.fillText(value, width, ' ', false);
    }

    public static synchronized String fillLeftSide(long value, int width, char fillingChar) {
        return TextUtil.fillText(Long.toString(value), width, fillingChar, true);
    }

    public static synchronized String fillLeftSide(String value, int width, char fillingChar) {
        return TextUtil.fillText(value, width, fillingChar, true);
    }

    public static synchronized String fillRightSide(String value, int width, char fillingChar) {
        return TextUtil.fillText(value, width, fillingChar, false);
    }

    public static synchronized boolean isNumeric(String textValue) {
        try {
            long value = Long.parseLong(textValue);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static synchronized boolean isDecimal(String textValue) {
        if (textValue == null) {
            return false;
        }
        for (int i = 0; i < textValue.length(); ++i) {
            char curChar = textValue.charAt(i);
            if (Character.isDigit(curChar) || curChar == '-' || curChar == '.') continue;
            return false;
        }
        return true;
    }

    public static synchronized boolean withinRange(String textValue, long lowerRange, long upperRange) {
        long currentValue = -1L;
        try {
            currentValue = Long.parseLong(textValue);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (currentValue != -1L) {
            return currentValue >= lowerRange && currentValue <= upperRange;
        }
        return false;
    }

    public static synchronized String doTrim(String word) {
        if (word != null) {
            return word.trim();
        }
        return "";
    }

    public static synchronized String fillText(String value, int width, char fillingChar, boolean fillingLeftSide) {
        Object resultantField = null;
        if (value == null) {
            return TextUtil.fillText(" ", width, fillingChar, fillingLeftSide);
        }
        int diff = width - value.length();
        if (diff < 0) {
            resultantField = value.substring(0, width);
        } else if (diff == 0) {
            resultantField = value;
        } else {
            String fillingSpace = TextUtil.createWord(fillingChar, diff);
            resultantField = fillingLeftSide ? fillingSpace + value : value + fillingSpace;
        }
        return resultantField;
    }

    public static synchronized String stripLeadingZeros(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '0') continue;
            return value.substring(i);
        }
        return "";
    }

    public static synchronized String composeWithSeparator(String[] data, String separator) {
        StringBuffer buffer = new StringBuffer();
        String result = null;
        if (data != null && data.length > 0) {
            for (int i = 0; i < data.length; ++i) {
                buffer.append(data[i]);
                if (i >= data.length - 1) continue;
                buffer.append(separator);
            }
            result = buffer.toString();
        }
        return result;
    }

    public static synchronized String stripSpecialChars(String word) {
        StringBuffer buffer = new StringBuffer(word.length());
        for (int i = 0; i < word.length(); ++i) {
            char currentChar = word.charAt(i);
            int charIndex = SPECIAL_CHAR_SET.indexOf(currentChar);
            if (charIndex != -1) {
                currentChar = FILTER_CHAR_SET.charAt(charIndex);
            }
            buffer.append(currentChar);
        }
        return buffer.toString();
    }

    public static synchronized String replace(StringBuffer sourceDocument, String startBlock, String endBlock, String newSectionData) {
        return TextUtil.replace(new StringReader(sourceDocument.toString()), startBlock, endBlock, newSectionData);
    }

    public static synchronized String replace(File targetFile, String startBlock, String endBlock, String newSectionData) {
        FileReader sourceFileReader = null;
        try {
            sourceFileReader = new FileReader(targetFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (sourceFileReader != null) {
            return TextUtil.replace(sourceFileReader, startBlock, endBlock, newSectionData);
        }
        return null;
    }

    public static synchronized String replace(Reader sourceDataReader, String startBlock, String endBlock, String newSectionData) {
        boolean sectionFound = false;
        StringBuffer data = new StringBuffer();
        try {
            boolean doRead = true;
            int endRead = 0;
            int startRead = 0;
            LineNumberReader lr = new LineNumberReader(sourceDataReader);
            String curLine = lr.readLine();
            do {
                startRead = 0;
                if (curLine.indexOf(startBlock) != -1) {
                    doRead = false;
                    endRead = curLine.indexOf(startBlock) + startBlock.length();
                    data.append(curLine.substring(startRead, endRead) + "\n");
                    data.append(newSectionData);
                    sectionFound = true;
                    if (curLine.indexOf(endBlock) != -1) {
                        startRead = curLine.indexOf(endBlock);
                        endRead = curLine.length();
                        data.append(curLine.substring(startRead, endRead) + "\n");
                        doRead = true;
                    }
                } else if (curLine.indexOf(endBlock) != -1) {
                    startRead = curLine.indexOf(endBlock);
                    doRead = true;
                }
                if (!doRead) continue;
                endRead = curLine.length();
                data.append(curLine.substring(startRead, endRead) + "\n");
            } while ((curLine = lr.readLine()) != null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (sectionFound) {
            return data.toString();
        }
        return null;
    }

    public static synchronized String fetchSectionData(File searchFile, String startBlock, String endBlock) {
        String fileContents = FileSystem.readStringFile(searchFile).toString();
        return TextUtil.getSectionText(fileContents, startBlock, endBlock);
    }

    public static synchronized String getSectionText(String targetText, String firstText, String lastText, int startPosition) {
        int startPos = startPosition;
        int endPos = targetText.length();
        if (firstText != null) {
            startPos = targetText.toLowerCase().indexOf(firstText.toLowerCase(), startPos);
            if (startPos != -1) {
                startPos += firstText.length();
            } else {
                return "";
            }
        }
        if (lastText != null) {
            endPos = targetText.toLowerCase().indexOf(lastText.toLowerCase(), startPos);
        }
        if (endPos == -1) {
            return "";
        }
        lastPosition = endPos != targetText.length() ? endPos : -1;
        return targetText.substring(startPos, endPos);
    }

    public static synchronized String getSectionText(String targetText, String firstText, String lastText) {
        return TextUtil.getSectionText(targetText, firstText, lastText, 0);
    }

    public static synchronized Vector<String> getAllSectionText(String targetText, String firstText, String lastText) {
        Vector<String> result = new Vector<String>();
        String lastResult = "   ";
        while (lastPosition != -1 && !lastResult.equals("")) {
            lastResult = TextUtil.getSectionText(targetText, firstText, lastText, lastPosition + 1);
            if (lastResult.equals("")) continue;
            result.add(lastResult);
        }
        return result;
    }

    public static synchronized boolean doEqual(String value, String compareValue) {
        return value != null && value.equals(compareValue);
    }

    public static synchronized boolean compare(String orig, String comp) {
        if (orig != null && comp != null) {
            return orig.equals(comp);
        }
        return orig == null && comp == null;
    }

    public static synchronized int occuranceOf(String word, String findString) {
        int occurance = 0;
        int curOccur = 0;
        int lastOcur = 0;
        while ((curOccur = word.indexOf(findString, lastOcur)) != -1) {
            ++occurance;
            lastOcur = curOccur + 1;
        }
        return occurance;
    }
}

