/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util;

import org.smyld.SMYLDObject;
import org.smyld.run.RunProcessListener;
import org.smyld.run.SMYLDRunProcess;
import org.smyld.security.SMYLDKey;

public class SMYLDJavaTools
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    SMYLDRunProcess curProcess;

    public void compile(String sourcePath, String targetClass, String targetPath, String libraryRef) throws Exception {
        if (targetClass == null) {
            throw new Exception("Class name to compile is not specified");
        }
        sourcePath = sourcePath != null ? " -sourcepath " + (String)sourcePath : "";
        targetPath = targetPath != null ? " -d " + (String)targetPath : "";
        Object classPath = libraryRef != null ? " -classpath " + libraryRef : "";
        String command = "javac " + (String)sourcePath + (String)classPath + (String)targetPath + targetClass;
        System.out.println("Executing Command : " + command + "\n\n\n");
        this.executeCommand(command, true);
    }

    public void createKey(SMYLDKey newKey) throws Exception {
        this.createKey(newKey.getName(), newKey.getPassword(), newKey.getDistinguishName(), newKey.getKeyStore());
    }

    public void createKey(String keyName, String keyPass, String distinguishName, String keyStore) throws Exception {
        if (keyName == null) {
            throw new Exception("Key name is mandatory ...");
        }
        StringBuffer command = new StringBuffer("keytool -genkey -alias ");
        command.append(keyName);
        final String curPass = keyPass;
        if (keyPass != null) {
            command.append(" -keypass " + keyPass);
        }
        if (keyStore != null) {
            command.append(" -keystore " + keyStore);
        }
        if (distinguishName != null) {
            command.append(" -dname \"" + distinguishName + "\"");
        }
        this.curProcess = this.executeCommand(command.toString(), new RunProcessListener(){

            @Override
            public void onError(String incError) {
                if (incError.startsWith("Enter keystore password")) {
                    try {
                        SMYLDJavaTools.this.curProcess.send(curPass);
                        SMYLDJavaTools.this.curProcess.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void onResponse(String response) {
                System.out.println("Incoming Reponse : " + response);
            }
        }, false);
    }

    public boolean signJarFile(String jarPath, SMYLDKey key) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("jarsigner");
        if (key.getKeyStore() != null) {
            buffer.append(" -keystore " + key.getKeyStore());
        }
        if (key.getPassword() != null) {
            buffer.append(" -storepass " + key.getPassword());
        }
        buffer.append(" " + jarPath);
        buffer.append(" " + key.getName());
        try {
            SMYLDRunProcess result = this.executeCommand(buffer.toString(), true);
            result.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public SMYLDRunProcess executeCommand(String command, boolean wait) throws Exception {
        System.out.println("Executing command : " + command);
        Runtime rt = Runtime.getRuntime();
        Process result = rt.exec(command);
        SMYLDRunProcess runningProcess = new SMYLDRunProcess(result);
        if (wait) {
            result.waitFor();
        }
        return runningProcess;
    }

    public SMYLDRunProcess executeCommand(String command, RunProcessListener prcListener, boolean wait) throws Exception {
        System.out.println("Executing command : " + command);
        Runtime rt = Runtime.getRuntime();
        Process result = rt.exec(command);
        SMYLDRunProcess runningProcess = new SMYLDRunProcess(result, prcListener);
        if (wait) {
            result.waitFor();
        }
        return runningProcess;
    }
}

