/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;
import org.smyld.io.FileNavigationListener;
import org.smyld.io.FilesNavigator;
import org.smyld.util.jar.JarEntryAlreadyExist;

public class SMYLDJARWriter
extends JarOutputStream {
    HashMap<String, JarEntry> entries;
    boolean printDuplicateEntries;
    String fileName;

    public SMYLDJARWriter(OutputStream out) throws IOException {
        super(out);
        this.entries = new HashMap();
        this.setComment("Created by SMYLD JAR API's utilities \n at " + new Date().toString());
    }

    public SMYLDJARWriter(String outName) throws IOException {
        super(new FileOutputStream(outName));
        this.fileName = outName;
        this.entries = new HashMap();
        this.setComment("Created by SMYLD JAR API's utilities \n at " + new Date().toString());
    }

    public void addLibrary(String jarLibPath) throws JarException, FileNotFoundException, IOException {
        CRC32 crc = new CRC32();
        byte[] data = null;
        JarInputStream jin = new JarInputStream(new FileInputStream(jarLibPath));
        JarEntry curInt = null;
        while ((curInt = jin.getNextJarEntry()) != null) {
            crc.reset();
            long activeSize = 0L;
            try {
                if (curInt.getName() == null || !curInt.getName().equals("META-INF/MANIFEST.MF")) {
                    this.putNextEntry(curInt);
                    int curSize = 0;
                    data = new byte[1024];
                    while ((curSize = jin.read(data)) != -1) {
                        crc.update(data, 0, curSize);
                        curInt.setSize(activeSize += (long)curSize);
                        curInt.setCrc(crc.getValue());
                        this.write(data, 0, curSize);
                    }
                }
                this.closeEntry();
            }
            catch (JarEntryAlreadyExist e) {
                if (!this.isPrintDuplicateEntries()) continue;
                System.out.println("Duplicate Entry : " + e.getJarEntry().getName());
            }
        }
    }

    public void putNextEntry(JarEntry newEntry) throws IOException, JarEntryAlreadyExist {
        if (this.entries.containsKey(newEntry.getName())) {
            throw new JarEntryAlreadyExist(newEntry);
        }
        this.entries.put(newEntry.getName(), newEntry);
        super.putNextEntry(newEntry);
    }

    public void addFile(String sourceFile, String targetFileName) throws JarException, FileNotFoundException, IOException, JarEntryAlreadyExist {
        FileInputStream fin = new FileInputStream(sourceFile);
        this.addStreamFile(fin, targetFileName);
    }

    public void addXMLFile(Element rootNode, String targetFileName) throws JarException, FileNotFoundException, IOException, JarEntryAlreadyExist {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        new XMLOutputter().output(rootNode, (OutputStream)outStream);
        ByteArrayInputStream in = new ByteArrayInputStream(outStream.toByteArray());
        this.addStreamFile(in, targetFileName);
    }

    public void addStreamFile(InputStream in, String targetFileName) throws JarException, FileNotFoundException, IOException, JarEntryAlreadyExist {
        long entrySize = 0L;
        targetFileName = this.correctTargetEntryName(targetFileName);
        JarEntry newFile = new JarEntry(targetFileName);
        this.putNextEntry(newFile);
        byte[] data = new byte[1024];
        int size = -1;
        while ((size = in.read(data)) != -1) {
            entrySize += (long)size;
            this.write(data, 0, size);
        }
        in.close();
        this.closeEntry();
    }

    private String correctTargetEntryName(String entryName) {
        StringBuffer curBuf = new StringBuffer(entryName.length());
        for (int i = 0; i < entryName.length(); ++i) {
            if (entryName.charAt(i) == '\\') {
                curBuf.append('/');
                continue;
            }
            curBuf.append(entryName.charAt(i));
        }
        return curBuf.toString();
    }

    public void createManifestFromAttribute(Attributes manAttributes) throws IOException, JarEntryAlreadyExist {
        this.createManifestFromAttribute(null, manAttributes);
    }

    public void createManifestFromAttribute(String manitFestFileName, Attributes manAttributes) throws IOException, JarEntryAlreadyExist {
        if (manitFestFileName == null) {
            manitFestFileName = "MANIFEST";
        }
        manitFestFileName = (String)manitFestFileName + ".MF";
        JarEntry manEntr = new JarEntry("META-INF/" + (String)manitFestFileName);
        this.putNextEntry(manEntr);
        String lineSep = System.getProperty("line.separator");
        Iterator<Object> itr = manAttributes.keySet().iterator();
        while (itr.hasNext()) {
            String attKey = ((Attributes.Name)itr.next()).toString();
            String attValue = manAttributes.getValue(attKey);
            String entry = attKey + ": " + attValue + lineSep;
            this.write(entry.getBytes());
        }
        this.closeEntry();
    }

    public void addFilesInFolder(final String targetBaseDir, final File folderPath, FileFilter filesFilter) throws IOException, FileNotFoundException {
        FilesNavigator navigator = new FilesNavigator();
        navigator.addNavigationListener(new FileNavigationListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void fileFound(File newFile) {
                Object targetFileName = SMYLDJARWriter.this.extractPackagePath(newFile.getPath(), folderPath.getPath());
                if (targetBaseDir != null) {
                    targetFileName = targetBaseDir + "/" + (String)targetFileName;
                }
                try {
                    if (!newFile.isDirectory() && targetFileName != null) {
                        SMYLDJARWriter.this.addFile(newFile.getPath(), (String)targetFileName);
                        return;
                    }
                    if (!newFile.isDirectory()) return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        navigator.navigate(folderPath, filesFilter);
    }

    public void addFilesInFolder(File folderPath, FileFilter filesFilter) throws IOException, FileNotFoundException {
        this.addFilesInFolder(null, folderPath, filesFilter);
    }

    protected String extractPackagePath(String filePath, String homePath) {
        String targetPath = null;
        int startIndex = filePath.indexOf(homePath);
        if (startIndex != -1) {
            targetPath = filePath.substring(startIndex + homePath.length() + 1);
        }
        return targetPath;
    }

    public boolean isPrintDuplicateEntries() {
        return this.printDuplicateEntries;
    }

    public void setPrintDuplicateEntries(boolean printDuplicateEntries) {
        this.printDuplicateEntries = printDuplicateEntries;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

