/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.util.vmapper;

import org.smyld.SMYLDObject;
import org.smyld.text.TextUtil;

public class VMapKeyInt
extends SMYLDObject
implements Comparable<Object> {
    private static final long serialVersionUID = 1L;
    int[][] valueRanges;
    String origKeyValue;
    String values;
    String singleValue;
    int singleIntValue;
    int diff = -1;
    boolean hasRanges;
    boolean hasSingleValue;

    public VMapKeyInt(String values) {
        this.origKeyValue = values;
        this.values = values;
        this.parseTextValues();
    }

    public VMapKeyInt() {
    }

    public void setValue(String value) {
        this.hasRanges = false;
        this.hasSingleValue = false;
        this.values = value;
        this.origKeyValue = value;
        this.parseTextValues();
    }

    public void setSingleValue(int value) {
        this.hasRanges = false;
        this.hasSingleValue = true;
        this.singleIntValue = value;
    }

    public int getSingleValue() {
        return this.singleIntValue;
    }

    public boolean isSingleValue() {
        return this.hasSingleValue;
    }

    private void parseTextValues() {
        StringBuffer buffer = new StringBuffer();
        String[] valueItems = this.values.split(",");
        int rangeNumber = TextUtil.occuranceOf(this.values, "-");
        if (rangeNumber > 0) {
            this.hasRanges = true;
            this.valueRanges = new int[rangeNumber][2];
        }
        if (valueItems.length == 1 && !this.hasRanges) {
            this.hasSingleValue = true;
            this.singleValue = this.values;
            this.singleIntValue = Integer.parseInt(this.singleValue);
        } else {
            int rangeIndex = 0;
            for (int i = 0; i < valueItems.length; ++i) {
                int sep = valueItems[i].indexOf("-");
                if (sep != -1) {
                    String minValue = valueItems[i].substring(0, sep);
                    String maxValue = valueItems[i].substring(sep + 1);
                    this.addSingleValue(buffer, minValue);
                    this.addSingleValue(buffer, maxValue);
                    int minIntValue = Integer.parseInt(minValue.trim());
                    int maxIntValue = Integer.parseInt(maxValue);
                    if (minIntValue > maxIntValue) {
                        this.valueRanges[rangeIndex][0] = maxIntValue;
                        this.valueRanges[rangeIndex][1] = minIntValue;
                    } else {
                        this.valueRanges[rangeIndex][0] = minIntValue;
                        this.valueRanges[rangeIndex][1] = maxIntValue;
                    }
                    ++rangeIndex;
                    continue;
                }
                this.addSingleValue(buffer, valueItems[i]);
            }
            if (buffer.length() > 0) {
                this.values = buffer.toString().substring(0, buffer.toString().length() - 1);
            }
        }
    }

    private void addSingleValue(StringBuffer buffer, String singleValue) {
        buffer.append("'");
        buffer.append(singleValue);
        buffer.append("'");
        buffer.append(",");
    }

    public boolean equals(int intValue) {
        this.diff = -1;
        if (this.hasSingleValue) {
            this.diff = this.singleIntValue - intValue;
            return intValue == this.singleIntValue;
        }
        if (this.values.indexOf("'" + intValue + "'") != -1) {
            return true;
        }
        if (this.hasRanges) {
            for (int i = 0; i < this.valueRanges.length; ++i) {
                if (intValue < this.valueRanges[i][0] || intValue > this.valueRanges[i][1]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        VMapKeyInt otherMap = (VMapKeyInt)obj;
        if (this.origKeyValue != null && otherMap.origKeyValue != null) {
            return otherMap.origKeyValue.equals(this.origKeyValue);
        }
        int value = ((VMapKeyInt)obj).getSingleValue();
        return this.equals(value);
    }

    public boolean equalsOriginalKeyText(String compareKey) {
        return this.origKeyValue.equals(compareKey);
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof String && this.equalsOriginalKeyText((String)o)) {
            return 0;
        }
        if (o.equals(this)) {
            return 0;
        }
        return this.diff;
    }
}

