/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.smyld.SMYLDObject;
import org.xml.sax.SAXException;

public class XMLParser
extends SMYLDObject {
    private static final long serialVersionUID = 1L;

    public org.w3c.dom.Document parseXmlFile(String filepath, boolean validating) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            org.w3c.dom.Document doc = factory.newDocumentBuilder().parse(new File(filepath));
            return doc;
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Document parseXmlFile(String filename) {
        try {
            SAXBuilder sxbuild = new SAXBuilder();
            Document doc = sxbuild.build(filename);
            return doc;
        }
        catch (IOException | JDOMException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeXML(String xmlpath, Document doc) {
        try {
            FileWriter writer = new FileWriter(xmlpath);
            XMLOutputter outp = new XMLOutputter();
            outp.setFormat(Format.getPrettyFormat().setTextMode(Format.TextMode.NORMALIZE));
            outp.output(doc, (Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String recoverXMLSymbols(String str) {
        str = str.replace('~', '<');
        str = str.replace('!', '>');
        return str;
    }

    public String replaceXMLSymbols(String str) {
        str = str.replace('<', '~');
        str = str.replace('>', '!');
        return str;
    }
}

