/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.bw.db;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import org.smyld.bw.data.structurs.BWUser;
import org.smyld.bw.db.DBName;
import org.smyld.bw.db.JavaDBValue;
import org.smyld.db.DBConnection;
import org.smyld.db.DBErrorHandler;
import org.smyld.db.SMYLDDBUtility;
import org.smyld.db.SMYLDDataBaseHandler;
import org.smyld.db.Utility;
import org.smyld.math.HexaDecimal;
import org.smyld.text.TextUtil;

public class BWDataBase
extends SMYLDDataBaseHandler
implements JavaDBValue,
DBName {
    private static final long serialVersionUID = 1L;

    public BWDataBase(DBErrorHandler e) {
        super(e);
    }

    public BWDataBase(DBErrorHandler e, DBConnection connection) {
        super(e, connection);
    }

    public BWDataBase(DBErrorHandler e, String userName, String userPassword, String host, String port, String dbname) {
        super(e, userName, userPassword, host, port, dbname);
    }

    public BWDataBase(int driver, DBErrorHandler e, String userName, String userPassword, String host, String port, String dbname) {
        super(driver, e, userName, userPassword, host, port, dbname);
    }

    public synchronized String createSequentialNumber(String tableName, String columnName, String institutionNo, int digitWidth) {
        long result = this.dbUtility.getSequentialID(tableName, columnName, "INSTITUTION_NUMBER", institutionNo);
        return TextUtil.fillLeftSide((long)result, (int)digitWidth, (char)'0');
    }

    public synchronized String createSequentialNumber(String tableName, String columnName, String institutionNo) {
        return this.createSequentialNumber(tableName, columnName, institutionNo, 11);
    }

    public synchronized String createSequentialNumber(String tableName, String columnName, int digitWidth) {
        long result = this.dbUtility.getSequentialID(tableName, columnName);
        return TextUtil.fillLeftSide((long)result, (int)digitWidth, (char)'0');
    }

    public String getAbsoluteSequenceValue(String seqName) {
        return TextUtil.fillLeftSide((String)seqName, (int)11, (char)'0');
    }

    public String getSequenceValue(String seqName) {
        return TextUtil.fillLeftSide((long)this.dbUtility.getSequenceValue(seqName), (int)11, (char)'0');
    }

    public String getSequenceValue(String seqName, int digitWidth) {
        return TextUtil.fillLeftSide((long)this.dbUtility.getSequenceValue(seqName), (int)digitWidth, (char)'0');
    }

    public synchronized String createSequentialNumber(String tableName, String columnName) {
        return this.createSequentialNumber(tableName, columnName, 11);
    }

    public HashMap<String, String> loadSysConfigSection(String sectionName) {
        ResultSet rsSection = this.dbUtility.getSingleParamSQL(sectionName, "Select CONFIG_KEYWORD, CONFIG_VALUE from SYS_CONFIGURATION Where CONFIG_SECTION=?");
        return this.getSectionValues(rsSection);
    }

    public HashMap<String, String> loadSysConfigSection(String sectionName, String institutionNo) {
        ResultSet rsSection = this.dbUtility.getDoubleParamSQL(sectionName, institutionNo, "Select CONFIG_KEYWORD, CONFIG_VALUE from SYS_CONFIGURATION Where CONFIG_SECTION=? AND INSTITUTION_NUMBER=?");
        return this.getSectionValues(rsSection);
    }

    public HashMap<String, String> getOracleTablesContainingFieldName(String fieldName) {
        return this.dbUtility.getTablesContainingFieldName(fieldName);
    }

    public String getOracleDirectoryPath(String directoryName) {
        return this.dbUtility.getOracleDirectory(directoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String> getSectionValues(ResultSet rsSection) {
        HashMap<String, String> result = null;
        if (rsSection != null) {
            try {
                while (rsSection.next()) {
                    if (result == null) {
                        result = new HashMap<String, String>();
                    }
                    String configKey = rsSection.getString("CONFIG_KEYWORD");
                    String keyValue = rsSection.getString("CONFIG_VALUE");
                    result.put(configKey, keyValue);
                }
            }
            catch (Exception ex) {
                this.handleDBError(ex);
            }
            finally {
                this.dbUtility.closeCursor(rsSection);
            }
        }
        return result;
    }

    public SMYLDDBUtility getSMYLDDBUtility() {
        return this.dbUtility;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getInstitutionsAvailableForConfigSection(String sectionName) {
        ResultSet rsInsts = this.dbUtility.getSingleParamSQL(sectionName, "Select  distinct INSTITUTION_NUMBER from SYS_CONFIGURATION Where CONFIG_SECTION=?");
        Vector<String> result = null;
        try {
            while (rsInsts.next()) {
                if (result == null) {
                    result = new Vector<String>();
                }
                String instNo = rsInsts.getString("INSTITUTION_NUMBER");
                result.add(instNo);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(rsInsts);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int callInsertExternal(String tableName, String procName) {
        int n;
        CallableStatement st = null;
        try {
            String funcText = Utility.constructTrippleParamFunctionCall((String)"Bw_Lib_Temptables.InsertUsingExternalTable");
            st = this.dbConnection.prepareCall(funcText);
            st.registerOutParameter(1, 2);
            st.setString(2, tableName);
            st.setString(3, "");
            st.setString(4, procName);
            st.execute();
            n = st.getInt(1);
        }
        catch (SQLException e) {
            try {
                this.handleDBError(e);
            }
            catch (Throwable throwable) {
                this.dbUtility.closeCursor(st);
                throw throwable;
            }
            this.dbUtility.closeCursor((PreparedStatement)st);
            return 0;
        }
        this.dbUtility.closeCursor((PreparedStatement)st);
        return n;
    }

    public int getTotalTablesSize(HashMap<String, String> tables) {
        int totalRecNo = 0;
        for (String curTableName : tables.keySet()) {
            totalRecNo += this.getTableTotalRecordsNumber(curTableName);
        }
        return totalRecNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, BWUser> loadUsers() {
        PreparedStatement pstUsers = null;
        ResultSet rsUsers = null;
        HashMap<String, BWUser> users = null;
        try {
            pstUsers = this.dbConnection.prepareStatement("Select * from SYS_USER_INFORMATION");
            rsUsers = pstUsers.executeQuery();
            while (rsUsers.next()) {
                if (users == null) {
                    users = new HashMap<String, BWUser>();
                }
                BWUser newUser = this.createUser(rsUsers);
                users.put(newUser.getID(), newUser);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(pstUsers);
        }
        return users;
    }

    public boolean doClientSessionExists(String clientID) {
        String sql = "select * from SYS.V_$SESSION where client_identifier='" + clientID + "'";
        return this.dbUtility.isExist(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BWUser loadUser(String usrID) {
        PreparedStatement pstUsers = null;
        ResultSet rsUsers = null;
        BWUser newUser = null;
        try {
            pstUsers = this.dbConnection.prepareStatement("Select * from SYS_USER_INFORMATION Where USERID=?");
            pstUsers.setString(1, usrID);
            rsUsers = pstUsers.executeQuery();
            if (rsUsers.next()) {
                newUser = this.createUser(rsUsers);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(pstUsers);
        }
        return newUser;
    }

    private BWUser createUser(ResultSet rsUser) throws Exception {
        BWUser newUser = new BWUser();
        newUser.setID(rsUser.getString("USERID"));
        newUser.setName(rsUser.getString("USERNAME"));
        newUser.setShortName(rsUser.getString("USERSHORTNAME"));
        newUser.setLanguage(rsUser.getString("LANGUAGE"));
        newUser.setBankCode(rsUser.getString("BANKCODE"));
        newUser.setBranchCode(rsUser.getString("BRANCHCODE"));
        newUser.setDeptCode(rsUser.getString("DEPARTMENTCODE"));
        newUser.setAdmin("-1".equals(rsUser.getString("ADMINISTRATOR")));
        newUser.setDeveloper("-1".equals(rsUser.getString("DEVELOPER")));
        newUser.setRs2Internal("-1".equals(rsUser.getString("INTERNALSMYLD")));
        newUser.setStatus(rsUser.getInt("STATUS"));
        newUser.setDefInst(rsUser.getString("DEFAULTINSTITUTION"));
        newUser.setPassword(rsUser.getString("PASS_WORD"));
        newUser.setAccessGroup(rsUser.getString("ACCESSGROUPS"));
        String validInsts = rsUser.getString("VALIDINSTITUTIONS");
        String validBin = HexaDecimal.convertToBinary((String)validInsts);
        for (int i = 0; i < validBin.length(); ++i) {
        }
        newUser.setAccessModule(rsUser.getString("MODULEACCESS"));
        return newUser;
    }
}

