/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.bw.db;

import org.smyld.bw.db.SQLStatements;
import org.smyld.db.schema.SchemaObject;
import org.smyld.db.schema.Table;

public class DynamicSQLStatements
extends SQLStatements {
    public static String getContractDetails(boolean useGroup, boolean getGroupClt) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Select inst_1.* , inst_2.CONTRACT_TYPE");
        if (getGroupClt) {
            buffer.append(",inst_5.CLIENT_NUMBER GROUP_CLIENT_NUMBER");
        }
        buffer.append(" from CBR_SERVICE_CONTRACT inst_2, CIS_CLIENT_LINKS inst_1");
        if (getGroupClt) {
            buffer.append(", CIS_CLIENT_LINKS inst_5");
        }
        buffer.append(" Where inst_2.INSTITUTION_NUMBER=inst_1.INSTITUTION_NUMBER AND inst_2.SERVICE_CONTRACT_ID=inst_1.SERVICE_CONTRACT_ID AND inst_2.CONTRACT_TYPE=? AND inst_1.CLIENT_NUMBER=? AND inst_1.INSTITUTION_NUMBER=? AND inst_1.CLIENT_LEVEL='001' AND inst_1.CONTRACT_STATUS> '000' AND inst_1.EFFECTIVE_DATE= (Select  MAX(EFFECTIVE_DATE)  from CBR_SERVICE_CONTRACT inst_3, CIS_CLIENT_LINKS inst_4 Where inst_3.INSTITUTION_NUMBER=inst_4.INSTITUTION_NUMBER AND inst_3.SERVICE_CONTRACT_ID=inst_4.SERVICE_CONTRACT_ID AND inst_3.CONTRACT_TYPE=? AND inst_4.CLIENT_NUMBER=? AND inst_4.INSTITUTION_NUMBER=? AND inst_4.CLIENT_LEVEL='001' AND inst_4.CONTRACT_STATUS> '000' AND inst_4.EFFECTIVE_DATE<= ?");
        if (useGroup) {
            buffer.append(" AND inst_4.GROUP_NUMBER=?");
            buffer.append(") ");
            buffer.append(" AND inst_1.GROUP_NUMBER=?");
        } else {
            buffer.append(") ");
        }
        if (getGroupClt) {
            buffer.append(" AND inst_5.INSTITUTION_NUMBER||''=inst_1.INSTITUTION_NUMBER AND inst_5.GROUP_NUMBER=inst_1.GROUP_NUMBER AND inst_5.PARENT_CLIENT_NUMBER||''=inst_1.INSTITUTION_NUMBER AND inst_5.SERVICE_CONTRACT_ID=inst_1.SERVICE_CONTRACT_ID AND inst_5.EFFECTIVE_DATE= (Select  MAX(EFFECTIVE_DATE)  from CIS_CLIENT_LINKS Where INSTITUTION_NUMBER=inst_5.INSTITUTION_NUMBER AND CLIENT_NUMBER=inst_5.CLIENT_NUMBER AND GROUP_NUMBER=inst_5.GROUP_NUMBER AND SERVICE_CONTRACT_ID=inst_5.SERVICE_CONTRACT_ID AND CLIENT_LEVEL=inst_5.CLIENT_LEVEL AND EFFECTIVE_DATE<= ?) ");
        }
        return buffer.toString();
    }

    public static String getCardUpdate(String targetTable) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Update ");
        buffer.append(targetTable);
        buffer.append(" Set ");
        buffer.append("CARD_NUMBER");
        buffer.append("=?");
        buffer.append(" Where ");
        buffer.append("ROWID");
        buffer.append("=?");
        return buffer.toString();
    }

    public static String getCardSelect(String targetTable) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Select ");
        buffer.append("ROWID");
        buffer.append(", ");
        buffer.append("CARD_NUMBER");
        buffer.append(" from ");
        buffer.append(targetTable);
        return buffer.toString();
    }

    public static String getTableSelect(Table table) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Select ");
        buffer.append("ROWID");
        for (SchemaObject curCol : table.getCols().values()) {
            buffer.append(", ");
            buffer.append(curCol.getName());
        }
        buffer.append(" from ");
        buffer.append(table.getName());
        return buffer.toString();
    }

    public static String getTableUpdate(Table table) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Update ");
        buffer.append(table.getName());
        buffer.append(" Set ");
        boolean firstItem = true;
        for (SchemaObject curCol : table.getCols().values()) {
            if (!firstItem) {
                buffer.append(", ");
            }
            buffer.append(curCol.getName());
            buffer.append("=?");
            firstItem = false;
        }
        buffer.append(" Where ");
        buffer.append("ROWID");
        buffer.append("=?");
        return buffer.toString();
    }

    public static String getInsertFile(String tableName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Insert into ");
        buffer.append(tableName);
        buffer.append(" (RECORD_DATE, AUDIT_TRAIL, CLEARING_CHANNEL, FILE_TYPE, FILE_ID, INSTITUTION_NUMBER, FILE_NUMBER, ORIGINAL_FILE_NAME, FILE_DATE, START_TIME, PROCESSING_STATUS, PROCESS_NAME, TRAN_DATA_LOCATION, USE_TEMP_TRAN_TABLE)  Values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ");
        return buffer.toString();
    }

    public static String getInsertProcessFile(String tableName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Insert into ");
        buffer.append(tableName);
        buffer.append(" (PROCESS_NUMBER, INSTITUTION_NUMBER, FILE_NUMBER)  Values (?, ?, ?) ");
        return buffer.toString();
    }

    public static String getCheckFile(String tableName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Select * from ");
        buffer.append(tableName);
        buffer.append("Select * from INT_FILE_LOG_DETAILS Where INSTITUTION_NUMBER=? AND FILE_ID=? AND ORIGINAL_FILE_NAME LIKE ? AND PROCESS_NAME=? AND PROCESSING_STATUS<>'003'");
        return buffer.toString();
    }
}

