/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.bw.util;

import java.io.File;
import org.smyld.bw.data.structurs.SystemJob;
import org.smyld.bw.db.BWDBAccess;
import org.smyld.text.TextUtil;
import org.smyld.util.SMYLDDate;
import org.smyld.util.Util;

public class BWUtility
extends Util {
    private static final long serialVersionUID = 1L;
    public static final String COUNTRY_CODE_DEFAULT = "";
    public static final String AUDIT_TRIAL_TRN_NO = "99998";

    public static synchronized String createAuditTrial(SystemJob currentSystemJob, String trnID) {
        return BWUtility.createAuditTrial(currentSystemJob.getUserID(), currentSystemJob.getStationNo(), trnID);
    }

    public static synchronized String createAuditTrial(String userID, String stationNo, String trnID) {
        SMYLDDate currentDate = new SMYLDDate();
        if (trnID == null) {
            trnID = AUDIT_TRIAL_TRN_NO;
        }
        String auditTrial = currentDate.toString("yyDDD-HHmmss") + "-" + userID + "-" + stationNo + (trnID != null ? "-" + trnID : COUNTRY_CODE_DEFAULT);
        return auditTrial;
    }

    public static synchronized String getValidValueRange(String value, int from, int to) {
        if (TextUtil.isEmpty((String)value)) {
            return null;
        }
        int intValue = -1;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (intValue < from && intValue > to || intValue == -1) {
            return null;
        }
        return value;
    }

    public static synchronized String validateCityName(String cityOriginalName) {
        char[] cityName = cityOriginalName.toCharArray();
        if (cityName[0] != '\f' && !Character.isDigit(cityName[0])) {
            for (int i = 0; i < cityName.length; ++i) {
                if (Character.isLetterOrDigit(cityName[i]) || cityName[i] == '*') continue;
                cityName[i] = 32;
            }
            if (cityName[0] != ' ') {
                return new String(cityName);
            }
        }
        return COUNTRY_CODE_DEFAULT;
    }

    public static synchronized double getISOAmount(String amount, int CurrencyExp) {
        double result;
        block4: {
            result = 0.0;
            if (!TextUtil.isEmpty((String)amount)) {
                amount = amount.trim();
                if (CurrencyExp >= 0) {
                    try {
                        result = (double)Integer.parseInt(amount) / Math.pow(10.0, CurrencyExp);
                    }
                    catch (Exception ex) {
                        result = (double)Integer.parseInt(amount.substring(1)) / Math.pow(10.0, CurrencyExp);
                        if (!amount.startsWith("D")) break block4;
                        result = -1.0 * result;
                    }
                }
            }
        }
        return result;
    }

    private static synchronized String addTrailingZeros(String value, int exp) {
        int dotLoc = value.indexOf(46);
        if (dotLoc != -1) {
            String decimalPart = value.substring(0, dotLoc);
            String partialPart = value.substring(dotLoc + 1);
            if (partialPart.length() < exp) {
                partialPart = TextUtil.fillRightSide((String)partialPart, (int)exp, (char)'0');
            }
            return decimalPart + '.' + partialPart;
        }
        return value;
    }

    public static synchronized double getISOAmount(String amount, String CurrCode) {
        int currExp = BWDBAccess.getCurrencyExponent(CurrCode);
        if (currExp != -1) {
            return BWUtility.getISOAmount(amount, currExp);
        }
        return 0.0;
    }

    public static synchronized String getISOAmountText(String amount, String CurrCode, boolean withTrailingZeros) {
        String result = Double.toString(BWUtility.getISOAmount(amount, CurrCode));
        if (withTrailingZeros) {
            return BWUtility.addTrailingZeros(result, BWDBAccess.getCurrencyExponent(CurrCode));
        }
        return result;
    }

    public static synchronized String getISOAmountText(String amount, String CurrCode) {
        return Double.toString(BWUtility.getISOAmount(amount, CurrCode));
    }

    public static synchronized String getISOAmountText(String amount, int CurrencyExp) {
        return Double.toString(BWUtility.getISOAmount(amount, CurrencyExp));
    }

    public static synchronized String getISOAmountText(String amount, int CurrencyExp, boolean withTrailingZeros) {
        String result = Double.toString(BWUtility.getISOAmount(amount, CurrencyExp));
        if (withTrailingZeros) {
            return BWUtility.addTrailingZeros(result, CurrencyExp);
        }
        return result;
    }

    public static synchronized String getCountryCode(String code) {
        if (!TextUtil.isEmpty((String)code)) {
            if (code.length() == 2) {
                return BWDBAccess.countryCodes2.get(code);
            }
            if (code.length() == 3) {
                return BWDBAccess.countryCodes3.get(code);
            }
        }
        return "999";
    }

    public static synchronized String getCountryByStateCode(String code) {
        return BWDBAccess.countryStateCodes.get(code);
    }

    public static synchronized boolean validateCountryState(String country, String state) {
        if (BWUtility.doHaveStateCode(country)) {
            String countryCode = BWDBAccess.countryStateCodes.get(state);
            if (countryCode != null) {
                return country.equals(countryCode);
            }
        } else if (TextUtil.isEmpty((String)state)) {
            return true;
        }
        return false;
    }

    public static synchronized boolean doHaveStateCode(String CountryCode) {
        return CountryCode != null && (CountryCode.equals("840") || CountryCode.equals("124") || CountryCode.equals("036"));
    }

    public static synchronized boolean validateAddress(String countryCode, String cityName, String stateCode, String postalCode) {
        boolean result = false;
        if (!TextUtil.isEmpty((String)countryCode) && !TextUtil.isEmpty((String)cityName)) {
            if (BWUtility.doHaveStateCode(countryCode)) {
                if (!TextUtil.isEmpty((String)stateCode)) {
                    if (!countryCode.equals("036") && !countryCode.equals(BWUtility.getCountryByStateCode(stateCode))) {
                        stateCode = null;
                    }
                    if (stateCode != null && !TextUtil.isEmpty((String)postalCode)) {
                        result = true;
                    }
                } else if (countryCode.equals("036")) {
                    result = true;
                }
            } else if (TextUtil.isEmpty((String)stateCode)) {
                result = true;
            }
        }
        return result;
    }

    public static synchronized String generateMaskFileName(String origNAme) throws Exception {
        File testFile = new File(origNAme);
        String fileName = testFile.getName();
        String pathName = testFile.getParent();
        StringBuffer buffer = new StringBuffer(fileName.length());
        StringBuffer dateBuffer = new StringBuffer();
        int datePos = 0;
        boolean insideMask = false;
        for (int i = 0; i < fileName.length(); ++i) {
            char curChar = fileName.charAt(i);
            if (curChar == '[') {
                insideMask = true;
                datePos = i;
                continue;
            }
            if (curChar == ']') {
                insideMask = false;
                continue;
            }
            if (insideMask) {
                dateBuffer.append(curChar);
                continue;
            }
            buffer.append(curChar);
        }
        SMYLDDate targetDate = new SMYLDDate(dateBuffer.toString());
        buffer.insert(datePos, targetDate.toString());
        String originalFile = pathName + File.separator + buffer.toString();
        return originalFile;
    }
}

