/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.bw.util;

import org.smyld.SMYLDObject;
import org.smyld.bw.util.MaskFormatException;
import org.smyld.text.TextUtil;
import org.smyld.util.SMYLDDate;

public class FileMaskHandler
extends SMYLDObject {
    private static final long serialVersionUID = 1L;
    StringBuffer buffer = new StringBuffer();
    public static final char FIRST_CHAR_JULIAN_DATE = 'J';
    public static final char FIRST_CHAR_YEAR = 'Y';
    public static final char FIRST_CHAR_MONTH_MINUTE = 'M';
    public static final char FIRST_CHAR_HOUR = 'H';
    public static final char FIRST_CHAR_SECOND = 'S';
    public static final char CHAR_COPY_ORIGIN = '*';
    public static final char CHAR_FORMAT_BEGIN = '<';
    public static final char CHAR_FORMAT_END = '>';
    public static final String PAT_DATE_YEAR = "Y";
    public static final String PAT_DATE_MONTH = "MM";
    public static final String PAT_DATE_DAY = "DD";
    public static final String PAT_DATE_HOUR = "HH";
    public static final String PAT_DATE_MINUTE = "MI";
    public static final String PAT_DATE_SECOND = "SS";
    public static final String PAT_DATE_JULIAN = "JJJ";
    public static final String PAT_DAILY_SEQ_0 = "$";
    public static final String PAT_DAILY_SEQ_1 = "#";
    public static final String PAT_DAILY_SEQ_1_ALL = "^";
    public static final String PAT_FILE_SEQ = "%";
    public static final String PAT_FILE_SEQ_YEARLY = "+";
    public static final String PAT_CLIENT_SPECIFIC = "U";
    public static final String PAT_SEQ_NUM = "nnn";
    public static final String PAT_INST_NUM = "!!!!!!!!";
    public static final String PAT_RESERVED = "YMDHISJ$#^%+Un!";

    public String convertToMask(String pattern) {
        if (this.isNew(pattern)) {
            return this.convertToNewMask(pattern);
        }
        return this.convertToOldMask(pattern);
    }

    public String convertToNewMask(String pattern) {
        this.buffer.setLength(0);
        boolean insidePattern = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char currentChar = pattern.charAt(i);
            if (currentChar == '<') {
                insidePattern = true;
                continue;
            }
            if (currentChar == '>') {
                insidePattern = false;
                continue;
            }
            if (insidePattern) {
                this.buffer.append('|');
                continue;
            }
            this.buffer.append(currentChar);
        }
        return this.buffer.toString();
    }

    public String convertToOldMask(String pattern) {
        this.buffer.setLength(0);
        for (int i = 0; i < pattern.length(); ++i) {
            char currentChar = pattern.charAt(i);
            if (PAT_RESERVED.indexOf(currentChar) == -1) {
                this.buffer.append(currentChar);
                continue;
            }
            this.buffer.append('|');
        }
        return this.buffer.toString();
    }

    public boolean match(String name, String mask) {
        if (name.length() == mask.length()) {
            for (int i = 0; i < name.length(); ++i) {
                char maskChar = mask.charAt(i);
                if (maskChar == '|' || maskChar == name.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean match(String name, String mask, String maskPattern) {
        if (this.match(name, mask)) {
            String FileNameMaskValue = this.getFileNameMaskValue(name, mask);
            return this.validate(maskPattern, FileNameMaskValue);
        }
        return false;
    }

    public String getFileNameMaskValue(String fileName, String fileMask) {
        this.buffer.setLength(0);
        for (int i = 0; i < fileMask.length(); ++i) {
            if (fileMask.charAt(i) != '|') continue;
            this.buffer.append(fileName.charAt(i));
        }
        return this.buffer.toString();
    }

    public String getFileMaskPattern(String Pattern) {
        if (this.isNew(Pattern)) {
            return this.getNewFileMaskPattern(Pattern);
        }
        return this.getOldFileMaskPattern(Pattern);
    }

    private boolean isNew(String pattern) {
        return pattern.indexOf(60) != -1 && pattern.indexOf(62) != -1;
    }

    public String getNewFileMaskPattern(String Pattern) {
        this.buffer.setLength(0);
        boolean insidePattern = false;
        for (int i = 0; i < Pattern.length(); ++i) {
            char currentChar = Pattern.charAt(i);
            if (currentChar == '<') {
                insidePattern = true;
                continue;
            }
            if (currentChar == '>') {
                insidePattern = false;
                continue;
            }
            if (!insidePattern) continue;
            this.buffer.append(currentChar);
        }
        return this.buffer.toString();
    }

    public String getOldFileMaskPattern(String Pattern) {
        this.buffer.setLength(0);
        for (int i = 0; i < Pattern.length(); ++i) {
            char currentChar = Pattern.charAt(i);
            if (PAT_RESERVED.indexOf(currentChar) == -1) continue;
            this.buffer.append(currentChar);
        }
        return this.buffer.toString();
    }

    public boolean validate(String maskPattern, String maskValue) {
        int position = 0;
        boolean result = true;
        this.buffer.setLength(0);
        String integerChecking = maskValue;
        if (maskPattern.indexOf(85) != -1) {
            for (int i = 0; i < maskPattern.length(); ++i) {
                if (maskPattern.charAt(i) == 'U') continue;
                this.buffer.append(maskValue.charAt(i));
            }
            integerChecking = this.buffer.toString();
            this.buffer.setLength(0);
        }
        if (!TextUtil.isNumeric((String)integerChecking)) {
            return false;
        }
        String value = null;
        while (position < maskPattern.length()) {
            char currentChar = maskPattern.charAt(position);
            switch (currentChar) {
                case 'Y': {
                    value = this.getCharsValue(maskValue, maskPattern, position, 'Y');
                    position += value.length();
                    if (value.length() != 4) break;
                    result = TextUtil.withinRange((String)value, (long)1900L, (long)2050L);
                    break;
                }
                case 'M': {
                    value = maskValue.substring(position, position + 2);
                    result = maskPattern.charAt(position + 1) == 'M' ? TextUtil.withinRange((String)value, (long)1L, (long)12L) : TextUtil.withinRange((String)value, (long)1L, (long)60L);
                    position += 2;
                    break;
                }
                case 'D': {
                    value = maskValue.substring(position, position + 2);
                    if (maskPattern.charAt(position + 1) != 'D') break;
                    result = TextUtil.withinRange((String)value, (long)1L, (long)31L);
                    position += 2;
                    break;
                }
                case 'H': {
                    value = maskValue.substring(position, position + 2);
                    if (maskPattern.charAt(position + 1) != 'H') break;
                    result = TextUtil.withinRange((String)value, (long)0L, (long)23L);
                    position += 2;
                    break;
                }
                case 'S': {
                    value = maskValue.substring(position, position + 2);
                    if (maskPattern.charAt(position + 1) != 'S') break;
                    result = TextUtil.withinRange((String)value, (long)1L, (long)60L);
                    position += 2;
                    break;
                }
                case 'J': {
                    value = maskValue.substring(position, position + 3);
                    if (!maskPattern.substring(position, position + 3).equals(PAT_DATE_JULIAN)) break;
                    result = TextUtil.withinRange((String)value, (long)1L, (long)366L);
                    position += 3;
                    break;
                }
                default: {
                    ++position;
                }
            }
            if (result) continue;
            return false;
        }
        return true;
    }

    private String getCharsValue(String value, String pattern, int startPosition, char targetChar) {
        this.buffer.setLength(0);
        while (pattern.charAt(startPosition) == targetChar) {
            this.buffer.append(value.charAt(startPosition));
            ++startPosition;
        }
        return this.buffer.toString();
    }

    public boolean compare(String textPattern, String textValue) {
        String patternMask = this.convertToMask(textPattern);
        String maskPattern = this.getFileMaskPattern(textPattern);
        return this.match(textValue, patternMask, maskPattern);
    }

    public boolean validate(String fileMask) throws MaskFormatException {
        block6: for (int i = 0; i < fileMask.length(); ++i) {
            char currentChar = fileMask.charAt(i);
            switch (currentChar) {
                case 'J': {
                    if (fileMask.indexOf(PAT_DATE_JULIAN) != -1) continue block6;
                    throw new MaskFormatException("Julian Date mask error");
                }
                case 'H': {
                    if (fileMask.indexOf(PAT_DATE_HOUR) != -1) continue block6;
                    throw new MaskFormatException("Hours mask error");
                }
                case 'S': {
                    if (fileMask.indexOf(PAT_DATE_SECOND) != -1) continue block6;
                    throw new MaskFormatException("Seconds mask error");
                }
                case 'M': {
                    if (fileMask.indexOf(PAT_DATE_MONTH) != -1 || fileMask.indexOf(PAT_DATE_MINUTE) != -1) continue block6;
                    throw new MaskFormatException("M exists  mask error");
                }
            }
        }
        return true;
    }

    public String changeFileNameUsingMask(String sourceFileName, String destMask) throws MaskFormatException {
        int fileNamePointPos = sourceFileName.indexOf(".");
        int maskPointPos = destMask.indexOf(".");
        SMYLDDate currentDate = new SMYLDDate();
        if (fileNamePointPos != -1) {
            if (maskPointPos != -1) {
                String fileName = sourceFileName.substring(0, fileNamePointPos);
                String fileExt = sourceFileName.substring(fileNamePointPos + 1);
                String maskName = destMask.substring(0, maskPointPos);
                String maskExt = destMask.substring(maskPointPos + 1);
                boolean isNewFormat = this.isNew(maskName) || this.isNew(maskExt);
                StringBuffer newName = new StringBuffer();
                if (isNewFormat) {
                    newName.append(this.changeUsingMaskNewFormat(fileName, maskName, currentDate));
                } else {
                    newName.append(this.changeUsingMaskOldFormat(fileName, maskName, currentDate));
                }
                newName.append(".");
                if (isNewFormat) {
                    newName.append(this.changeUsingMaskNewFormat(fileExt, maskExt, currentDate));
                } else {
                    newName.append(this.changeUsingMaskOldFormat(fileExt, maskExt, currentDate));
                }
                return newName.toString();
            }
            throw new MaskFormatException("Mask does not contain extension separator");
        }
        throw new MaskFormatException("File name does not contain extension");
    }

    private String changeUsingMaskNewFormat(String sourceName, String destMask, SMYLDDate currentDate) throws MaskFormatException {
        boolean insideFormat = false;
        if (currentDate == null) {
            currentDate = new SMYLDDate();
        }
        this.buffer.setLength(0);
        block4: for (int i = 0; i < destMask.length(); ++i) {
            char currentChar = destMask.charAt(i);
            switch (currentChar) {
                case '<': {
                    insideFormat = true;
                    continue block4;
                }
                case '>': {
                    insideFormat = false;
                    continue block4;
                }
                default: {
                    if (insideFormat) {
                        i += this.convertMask(this.buffer, sourceName, destMask, i, currentChar, currentDate);
                        continue block4;
                    }
                    this.buffer.append(currentChar);
                }
            }
        }
        return this.buffer.toString();
    }

    private String changeUsingMaskOldFormat(String sourceName, String destMask, SMYLDDate currentDate) throws MaskFormatException {
        if (currentDate == null) {
            currentDate = new SMYLDDate();
        }
        this.buffer.setLength(0);
        for (int i = 0; i < destMask.length(); ++i) {
            char currentChar = destMask.charAt(i);
            int advancePos = this.convertMask(this.buffer, sourceName, destMask, i, currentChar, currentDate);
            if (advancePos == -1) {
                this.buffer.append(currentChar);
                continue;
            }
            i += advancePos;
        }
        return this.buffer.toString();
    }

    private int convertMask(StringBuffer resultBuffer, String sourceName, String destMask, int pos, char currentChar, SMYLDDate currentDate) throws MaskFormatException {
        int advancingCharacter = -1;
        switch (currentChar) {
            case '*': {
                resultBuffer.append(sourceName);
                advancingCharacter = 0;
                break;
            }
            case 'J': {
                String julianDateMask = destMask.substring(pos, pos + 3);
                if (julianDateMask != null && julianDateMask.equals(PAT_DATE_JULIAN)) {
                    resultBuffer.append(currentDate.toString("DDD"));
                    advancingCharacter = 2;
                    break;
                }
                throw new MaskFormatException("Wrong Julian Date");
            }
            case 'H': {
                String hourMask = destMask.substring(pos, pos + 2);
                if (hourMask != null && hourMask.equals(PAT_DATE_HOUR)) {
                    resultBuffer.append(currentDate.toString(PAT_DATE_HOUR));
                    advancingCharacter = 1;
                    break;
                }
                throw new MaskFormatException("Wrong hours mask");
            }
            case 'S': {
                String secondsMask = destMask.substring(pos, pos + 2);
                if (secondsMask != null && secondsMask.equals(PAT_DATE_SECOND)) {
                    resultBuffer.append(currentDate.toString("ss"));
                    advancingCharacter = 1;
                    break;
                }
                throw new MaskFormatException("Wrong seconds mask");
            }
            case 'M': {
                String monthMinuteMask = destMask.substring(pos, pos + 2);
                if (monthMinuteMask != null) {
                    if (monthMinuteMask.equals(PAT_DATE_MINUTE)) {
                        resultBuffer.append(currentDate.toString("mm"));
                        advancingCharacter = 1;
                        break;
                    }
                    if (monthMinuteMask.equals(PAT_DATE_MONTH)) {
                        resultBuffer.append(currentDate.toString(PAT_DATE_MONTH));
                        advancingCharacter = 1;
                        break;
                    }
                }
                throw new MaskFormatException("Wrong monthes/minutes mask");
            }
        }
        return advancingCharacter;
    }
}

