/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.bw.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.smyld.text.EnvelopTockenizer;
import org.smyld.text.TextTokenizer;

public class ParametersSet
implements Serializable {
    ArrayList<HashMap<String, String>> parameterSets = new ArrayList();
    int paramSetsRealCount;
    static final long serialVersionUID = 4223910564156435384L;
    public static final String PARAM_ENV_START = "{";
    public static final String PARAM_ENV_END = "}";
    public static final String PARAM_SEP = "|";
    public static final String PARAM_NAME_SEP = "=>";
    public static final String PARAM_VALUE_START = "'";
    public static final String PARAM_VALUE_END = "'";

    public ParametersSet(String parameters) {
        if (parameters != null) {
            EnvelopTockenizer paramsTockenizer = new EnvelopTockenizer(parameters, PARAM_ENV_START, PARAM_ENV_END);
            this.parseParameters(paramsTockenizer.parseEnvelops());
        }
    }

    public ParametersSet() {
        this.parameterSets.add(new HashMap());
    }

    private void parseParameters(String[] tockenizedParameterSets) {
        for (int i = 0; i < tockenizedParameterSets.length; ++i) {
            HashMap<String, String> currentParameterSet = this.parseParametersSet(tockenizedParameterSets[i]);
            if (currentParameterSet == null) continue;
            this.parameterSets.add(i, currentParameterSet);
        }
    }

    private HashMap<String, String> parseParametersSet(String parametersSet) {
        HashMap<String, String> resultantParameterSet = null;
        TextTokenizer currentParamterSet = new TextTokenizer(parametersSet, PARAM_SEP);
        String[] parameters = currentParamterSet.parseTokens();
        for (int i = 0; i < parameters.length; ++i) {
            if (resultantParameterSet == null) {
                resultantParameterSet = new HashMap<String, String>(parameters.length);
            }
            String paramName = parameters[i].substring(0, parameters[i].indexOf(PARAM_NAME_SEP));
            String paramValue = parameters[i].substring(parameters[i].indexOf("'") + "'".length(), parameters[i].lastIndexOf("'"));
            resultantParameterSet.put(paramName.toLowerCase(), paramValue);
        }
        return resultantParameterSet;
    }

    public int addParametersSet() {
        HashMap newSet = new HashMap();
        this.parameterSets.add(newSet);
        return this.parameterSets.size();
    }

    public void addParameter(int paramSet, String newParmName, String newParamValue) {
        HashMap<String, String> targetSet = this.getParameterSet(paramSet);
        if (targetSet != null) {
            if (paramSet > this.paramSetsRealCount) {
                this.paramSetsRealCount = paramSet;
            }
            targetSet.put(newParmName.toLowerCase(), newParamValue);
        }
    }

    public void addParameter(String newParmName, String newParamValue) {
        HashMap<String, String> targetSet = this.getParameterSet(0);
        if (targetSet != null) {
            targetSet.put(newParmName.toLowerCase(), newParamValue);
        }
    }

    public HashMap<String, String> getParameterSet(int paramSet) {
        if (this.parameterSets.size() >= paramSet) {
            HashMap<String, String> targetSet = this.parameterSets.get(paramSet - 1);
            return targetSet;
        }
        return null;
    }

    public String getParameterValue(int parameterSet, String parameterName) {
        String targetObject;
        HashMap<String, String> targetSet = this.getParameterSet(parameterSet);
        if (targetSet != null && (targetObject = targetSet.get(parameterName.toLowerCase())) != null) {
            return targetObject.toString();
        }
        return null;
    }

    public String getParameterValue(String parameterName) {
        return this.getParameterValue(1, parameterName);
    }

    public String printParameters() {
        StringBuffer value = new StringBuffer();
        for (HashMap<String, String> currentSet : this.parameterSets) {
            if (currentSet == null || currentSet.size() <= 0) continue;
            value.append(PARAM_ENV_START + this.printParameterSet(currentSet) + PARAM_ENV_END);
        }
        return value.toString();
    }

    private String printParameterSet(HashMap<String, String> currentParameterSet) {
        StringBuffer value = new StringBuffer();
        if (currentParameterSet.size() > 0) {
            Iterator<String> items = currentParameterSet.keySet().iterator();
            while (items.hasNext()) {
                String parameterName = items.next();
                String parameterValue = currentParameterSet.get(parameterName).toString();
                value.append(parameterName + PARAM_NAME_SEP + "'" + parameterValue + "'");
                if (!items.hasNext()) continue;
                value.append(PARAM_SEP);
            }
            return value.toString();
        }
        return "ParameterSetEmpty";
    }

    public int getSetsCount() {
        return this.paramSetsRealCount;
    }
}

