/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.bw.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.smyld.bw.data.structurs.Channel;
import org.smyld.bw.data.structurs.ClientLink;
import org.smyld.bw.data.structurs.Country;
import org.smyld.bw.data.structurs.Currency;
import org.smyld.bw.data.structurs.ProcessSetup;
import org.smyld.bw.data.structurs.ServiceContract;
import org.smyld.bw.data.structurs.SystemJob;
import org.smyld.bw.data.structurs.TranType;
import org.smyld.bw.db.BWDataBase;
import org.smyld.bw.db.DynamicSQLStatements;
import org.smyld.db.DBConnection;
import org.smyld.db.DBErrorHandler;
import org.smyld.err.CardConflictException;
import org.smyld.text.TextUtil;

public class BWDBAccess
extends BWDataBase {
    private static final long serialVersionUID = 1L;
    public static HashMap<String, String> countryCodes2;
    public static HashMap<String, String> countryCodes3;
    public static HashMap<String, Country> countrys;
    public static HashMap<String, Channel> channels;
    public static HashMap<String, TranType> transTypes;
    public static HashMap<String, String> isoBussClass;
    public static HashMap<String, String> idxBussClass;
    public static HashMap<String, String> extraChargesCarRental;
    public static HashMap<String, String> extraChargesLodging;
    public static HashMap<String, String> countryStateCodes;
    public static HashMap<String, String> systemCountryRegion;
    public static HashMap<String, String> regions;
    public static HashMap<String, Currency> currencies;
    public static HashMap<String, String> interchangeDetails;
    public static final String CHANNEL_ID_NOT_EXIST = "999";

    public BWDBAccess(int driver, DBErrorHandler e, String userName, String userPassword, String host, String port, String dbname) {
        super(driver, e, userName, userPassword, host, port, dbname);
    }

    public BWDBAccess(DBErrorHandler e, DBConnection connection) {
        super(e, connection);
        this.init();
    }

    public BWDBAccess(DBErrorHandler e) {
        super(e);
        this.init();
    }

    public void init() {
        this.loadChannels();
        this.loadTransactionTypes();
        this.loadISOBussClasses();
        this.loadExtraChargesCarRental();
        this.loadExtraChargesLodging();
        this.loadCountryStateCodes();
        this.loadCountryCodes();
        this.loadSystemCountryRegion();
        this.loadRegions();
        this.loadCurrencies();
        this.loadInterchangeDetails();
    }

    public synchronized void deleteFile(String institutionNo, String fileNo) {
        this.dbUtility.doDoubleParamSQL(institutionNo, fileNo, "Delete from INT_FILE_LOG_DETAILS Where INSTITUTION_NUMBER=? AND FILE_NUMBER=?");
        this.dbUtility.doDoubleParamSQL(institutionNo, fileNo, "Delete from INT_PROCESS_FILE_LOG Where INSTITUTION_NUMBER=? AND FILE_NUMBER=?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ProcessSetup loadProcessSetup(String processName, String institutionNum) {
        ResultSet rs;
        ProcessSetup newProcessSetup;
        block4: {
            newProcessSetup = null;
            rs = null;
            try {
                rs = this.dbUtility.getDoubleParamSQL(processName, institutionNum, "Select FILE_PATH, FILE_MASK, FILE_MOVE_PATH, FILE_RENAME_MASK from SYS_PROCESS_USER_SETUP Where PROCESS_NAME=? AND INSTITUTION_NUMBER=?");
                if (!rs.next()) break block4;
                newProcessSetup = new ProcessSetup();
                newProcessSetup.setFileMask(rs.getString("FILE_MASK"));
                newProcessSetup.setFilePath(rs.getString("FILE_PATH"));
                newProcessSetup.setFileMovePath(rs.getString("FILE_MOVE_PATH"));
                newProcessSetup.setFileRenameMask(rs.getString("FILE_RENAME_MASK"));
            }
            catch (Exception ex) {
                try {
                    this.handleDBError(ex);
                }
                catch (Throwable throwable) {
                    this.dbUtility.closeCursor(rs);
                    throw throwable;
                }
                this.dbUtility.closeCursor(rs);
            }
        }
        this.dbUtility.closeCursor(rs);
        return newProcessSetup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeComponentVersion(String newVersion, String productID, String compID) {
        PreparedStatement st = null;
        try {
            String sql = "update BW_COMPONENT_VERSION set COMP_VERSION = ? where COMP_PRODUCT = ? and COMP_ID = ?";
            st = this.dbConnection.prepareStatement(sql);
            st.setString(1, newVersion);
            st.setString(2, productID);
            st.setString(3, compID);
            st.executeUpdate();
        }
        catch (Exception ex) {
            try {
                this.handleDBError(ex);
            }
            catch (Throwable throwable) {
                this.dbUtility.closeCursor(st);
                throw throwable;
            }
            this.dbUtility.closeCursor(st);
        }
        this.dbUtility.closeCursor(st);
    }

    public static Currency getCurrency(String currCode) {
        return currencies.get(currCode);
    }

    public static int getCurrencyExponent(String currCode) {
        Currency targetCurrency = BWDBAccess.getCurrency(currCode);
        if (targetCurrency != null) {
            return targetCurrency.getExponent();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SystemJob createJob(String processNumber) {
        SystemJob requestedJob = null;
        ResultSet rsProcessLog = null;
        ResultSet rsProcessLogParams = null;
        try {
            rsProcessLog = this.dbUtility.getSingleParamSQL(processNumber, "Select * from INT_PROCESS_LOG Where INT_PROCESS_LOG.PROCESS_NUMBER=?");
            if (rsProcessLog.next()) {
                String no = rsProcessLog.getString("PROCESS_NUMBER");
                String id = rsProcessLog.getString("PROCESS_ID");
                String name = rsProcessLog.getString("PROCESS_NAME");
                String institutionNo = rsProcessLog.getString("INSTITUTION_NUMBER");
                String stationNo = rsProcessLog.getString("STATION_NUMBER");
                String userID = rsProcessLog.getString("USER_ID");
                String postingDate = rsProcessLog.getString("POSTING_DATE");
                String parentPrcNo = rsProcessLog.getString("PARENT_PROCESS_NUMBER");
                requestedJob = new SystemJob(no, id, name, institutionNo, stationNo, userID, postingDate);
                rsProcessLogParams = this.dbUtility.getSingleParamSQL(processNumber, "Select INT_PROCESS_PARAMS.PARAMETER_VALUE from INT_PROCESS_PARAMS Where INT_PROCESS_PARAMS.PARAM_TYPE='IN' AND INT_PROCESS_PARAMS.PROCESS_NUMBER=?");
                while (rsProcessLogParams.next()) {
                    String paramValue = rsProcessLogParams.getString("PARAMETER_VALUE");
                    requestedJob.setParametersIn(paramValue);
                    requestedJob.setParentProcessNo(parentPrcNo);
                }
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(rsProcessLog);
            this.dbUtility.closeCursor(rsProcessLogParams);
        }
        return requestedJob;
    }

    public synchronized void updateJobParameters(SystemJob targetJob) {
        if (targetJob.getParamOutSetsCount() > 0) {
            this.dbUtility.executeDoubleParamProcedure("Bw_Process_Control.Saveparameterout", targetJob.getNo(), targetJob.getParametersOutValue());
        }
    }

    public synchronized boolean updateFilePrcStatus(String institutionNo, String fileNumber, String prcStatus) {
        int result = this.dbUtility.doTrippleParamUpdateSQL(prcStatus, fileNumber, institutionNo, "Update INT_FILE_LOG_DETAILS Set PROCESSING_STATUS=? Where FILE_NUMBER=? AND INSTITUTION_NUMBER=?");
        return result > 0;
    }

    public synchronized boolean updateIntFilePrcStatus(String institutionNo, String fileNumber, String prcStatus) {
        int result = this.dbUtility.doTrippleParamUpdateSQL(prcStatus, fileNumber, institutionNo, "Update INT_FILE_LOG_DETAILS Set PROCESSING_STATUS=? Where FILE_NUMBER=? AND INSTITUTION_NUMBER=?");
        return result > 0;
    }

    public synchronized ResultSet getClientDetailsForExRef(String institutionNo, String clientExRef) {
        return this.dbUtility.getDoubleParamSQL(institutionNo, clientExRef, "Select CLIENT_NUMBER, CLIENT_REGION, CLIENT_STATE, BUSINESS_CLASS, CLIENT_COUNTRY, CLIENT_CITY, CLIENT_STATUS, RCC, POST_CODE, TRADE_NAME, SERVICE_TEL_NUMBER from CIS_CLIENT_DETAILS Where INSTITUTION_NUMBER=? AND OUR_REFERENCE=? Order By CLIENT_STATUS");
    }

    public synchronized ResultSet getClientRefDetailsForExRef(String institutionNo, String clientExRef, String clientRefType) {
        return this.dbUtility.getQuadParamSQL(institutionNo, clientExRef, clientExRef, clientRefType, "Select CIS_CLIENT_DETAILS.CLIENT_NUMBER, CLIENT_REGION, CLIENT_STATE, BUSINESS_CLASS, CLIENT_COUNTRY, CLIENT_CITY, CLIENT_STATUS, RCC, POST_CODE, TRADE_NAME, CLIENT_REFERENCE_NUMBER, SERVICE_TEL_NUMBER, COMPANY_NAME from CIS_CLIENT_DETAILS, CIS_CLIENT_REFERENCE Where CIS_CLIENT_DETAILS.INSTITUTION_NUMBER=? AND CIS_CLIENT_DETAILS.OUR_REFERENCE=? AND CIS_CLIENT_REFERENCE.CLIENT_NUMBER (+)=CIS_CLIENT_DETAILS.CLIENT_NUMBER AND CIS_CLIENT_REFERENCE.INSTITUTION_NUMBER (+)=CIS_CLIENT_DETAILS.INSTITUTION_NUMBER AND CIS_CLIENT_REFERENCE.CLIENT_REFERENCE_TYPE (+)=? Order By CLIENT_STATUS");
    }

    public synchronized ResultSet getClientRefDetailsForExRef(String institutionNo, String clientExRef, String clientRefType, boolean byRegistrationNo) {
        if (byRegistrationNo) {
            return this.dbUtility.getTrippleParamSQL(institutionNo, clientExRef, clientRefType, "Select CIS_CLIENT_DETAILS.CLIENT_NUMBER, CLIENT_REGION, CLIENT_STATE, BUSINESS_CLASS, CLIENT_COUNTRY, CLIENT_CITY, CLIENT_STATUS, RCC, POST_CODE, TRADE_NAME, CLIENT_REFERENCE_NUMBER, SERVICE_TEL_NUMBER, COMPANY_NAME from CIS_CLIENT_DETAILS, CIS_CLIENT_REFERENCE Where CIS_CLIENT_DETAILS.INSTITUTION_NUMBER=? AND CIS_CLIENT_DETAILS.REGISTRATION_NUMBER=? AND CIS_CLIENT_REFERENCE.CLIENT_NUMBER (+)=CIS_CLIENT_DETAILS.CLIENT_NUMBER AND CIS_CLIENT_REFERENCE.INSTITUTION_NUMBER (+)=CIS_CLIENT_DETAILS.INSTITUTION_NUMBER AND CIS_CLIENT_REFERENCE.CLIENT_REFERENCE_TYPE (+)=? Order By CLIENT_STATUS");
        }
        return this.dbUtility.getTrippleParamSQL(institutionNo, clientExRef, clientRefType, "Select CIS_CLIENT_DETAILS.CLIENT_NUMBER, CLIENT_REGION, CLIENT_STATE, BUSINESS_CLASS, CLIENT_COUNTRY, CLIENT_CITY, CLIENT_STATUS, RCC, POST_CODE, TRADE_NAME, CLIENT_REFERENCE_NUMBER, SERVICE_TEL_NUMBER, COMPANY_NAME from CIS_CLIENT_DETAILS, CIS_CLIENT_REFERENCE Where CIS_CLIENT_DETAILS.INSTITUTION_NUMBER=? AND CIS_CLIENT_DETAILS.OUR_REFERENCE=? AND CIS_CLIENT_REFERENCE.CLIENT_NUMBER (+)=CIS_CLIENT_DETAILS.CLIENT_NUMBER AND CIS_CLIENT_REFERENCE.INSTITUTION_NUMBER (+)=CIS_CLIENT_DETAILS.INSTITUTION_NUMBER AND CIS_CLIENT_REFERENCE.CLIENT_REFERENCE_TYPE (+)=? Order By CLIENT_STATUS");
    }

    public synchronized boolean doINTFileExist(String fileID, SystemJob systemJob) {
        return this.doFileExist(fileID, systemJob, "Select * from INT_FILE_LOG_DETAILS Where INSTITUTION_NUMBER=? AND FILE_ID=? AND ORIGINAL_FILE_NAME LIKE ? AND PROCESS_NAME=? AND PROCESSING_STATUS<>'003' AND PROCESSING_STATUS<>'017'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean doFileExist(String fileID, SystemJob systemJob, String sql) {
        boolean fileExist = false;
        PreparedStatement pstFileCheck = null;
        ResultSet rsFileCheck = null;
        try {
            pstFileCheck = this.dbConnection.prepareStatement(sql);
            String fileName = systemJob.getParameterIn("p_filename");
            pstFileCheck.setString(1, systemJob.getInstitutionNo());
            pstFileCheck.setString(2, fileID);
            pstFileCheck.setString(3, fileName + "%");
            pstFileCheck.setString(4, systemJob.getName());
            System.out.println("FILE ID:" + fileID);
            rsFileCheck = pstFileCheck.executeQuery();
            fileExist = rsFileCheck.next();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(pstFileCheck);
        }
        return fileExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean doFileExist(String fileID, String processName) {
        boolean fileExist = false;
        PreparedStatement pstFileCheck = null;
        ResultSet rsFileCheck = null;
        try {
            pstFileCheck = this.dbConnection.prepareStatement("Select * from INT_FILE_LOG_DETAILS Where FILE_ID=? AND PROCESS_NAME=?");
            pstFileCheck.setString(1, fileID);
            pstFileCheck.setString(2, processName);
            rsFileCheck = pstFileCheck.executeQuery();
            fileExist = rsFileCheck.next();
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(pstFileCheck);
        }
        return fileExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HashMap<String, Channel> loadChannels() {
        channels = new HashMap();
        ResultSet rsChannels = null;
        try {
            rsChannels = this.dbUtility.executeQuery("Select * from CBR_CHANNEL_DEFINITION");
            while (rsChannels.next()) {
                String trnSource = rsChannels.getString("TRANSACTION_SOURCE");
                String trnDestination = rsChannels.getString("TRANSACTION_DESTINATION");
                String InstitutionNo = rsChannels.getString("INSTITUTION_NUMBER");
                String TranCurrency = rsChannels.getString("TRAN_CURRENCY");
                String SettlementCurrency = rsChannels.getString("SETTLEMENT_CURRENCY");
                String ClientNo = rsChannels.getString("CLIENT_NUMBER");
                String ClientBussType = rsChannels.getString("CLIENT_BUSINESS_TYPE");
                String InterchangeInstitution = rsChannels.getString("INTERCHANGE_INSTITUTION");
                String AuditTrail = rsChannels.getString("AUDIT_TRAIL");
                String RecordDate = rsChannels.getString("RECORD_DATE");
                String RecordType = rsChannels.getString("RECORD_TYPE");
                String CardOrganization = rsChannels.getString("CARD_ORGANIZATION");
                String AreaOfEvent = rsChannels.getString("AREA_OF_EVENT");
                String ServiceType = rsChannels.getString("SERVICE_TYPE");
                String ChargeType = rsChannels.getString("CHARGE_TYPE");
                String channelID = trnSource;
                if (trnSource.equals(CHANNEL_ID_NOT_EXIST)) {
                    channelID = trnDestination;
                }
                Channel newChannel = new Channel(InstitutionNo, channelID, TranCurrency, SettlementCurrency, ClientNo, ClientBussType, InterchangeInstitution, AuditTrail, RecordDate, RecordType, CardOrganization, AreaOfEvent, ServiceType, ChargeType);
                channels.put(newChannel.getKey(), newChannel);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
            channels = null;
        }
        finally {
            this.dbUtility.closeCursor(rsChannels);
        }
        return channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadInterchangeDetails() {
        interchangeDetails = new HashMap();
        String lastKey = null;
        int keyCount = 0;
        ResultSet rsDet = this.dbUtility.executeQuery("Select INSTITUTION_NUMBER, CARD_ORGANIZATION, CLIENT_REGION from CIS_INTERCHANGE_DETAILS Order By INSTITUTION_NUMBER, CARD_ORGANIZATION, CLIENT_REGION");
        try {
            while (rsDet.next()) {
                String detInst = rsDet.getString("INSTITUTION_NUMBER");
                String detCardOrg = rsDet.getString("CARD_ORGANIZATION");
                String detClientRegion = rsDet.getString("CLIENT_REGION");
                String detailKey = detInst + detCardOrg + detClientRegion;
                if (lastKey == null) {
                    lastKey = detailKey;
                    keyCount = 1;
                } else if (lastKey.equals(detailKey)) {
                    ++keyCount;
                } else {
                    interchangeDetails.put(lastKey, Integer.toString(keyCount));
                    lastKey = detailKey;
                    keyCount = 1;
                }
                if (interchangeDetails.containsKey(lastKey)) continue;
                interchangeDetails.put(lastKey, Integer.toString(keyCount));
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(rsDet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadTransactionTypes() {
        transTypes = new HashMap();
        ResultSet rsTans = this.dbUtility.executeQuery("Select * from BWT_TRANSACTION_TYPE");
        try {
            while (rsTans.next()) {
                String tranIndex = rsTans.getString("INDEX_FIELD");
                String tranSrcSign = rsTans.getString("SOURCE_SIGN");
                String tranDestSign = rsTans.getString("DESTINATION_SIGN");
                TranType newTransType = new TranType(tranIndex, tranSrcSign, tranDestSign);
                transTypes.put(newTransType.getIndex(), newTransType);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(rsTans);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadISOBussClasses() {
        isoBussClass = new HashMap();
        idxBussClass = new HashMap();
        ResultSet rsBuss = this.dbUtility.executeQuery("Select ISO_CODE, INDEX_FIELD from BWT_ISO_BUSS_CLASS");
        try {
            while (rsBuss.next()) {
                String indexField = rsBuss.getString("INDEX_FIELD");
                String isoCode = rsBuss.getString("ISO_CODE");
                isoBussClass.put(indexField, isoCode);
                idxBussClass.put(isoCode, indexField);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(rsBuss);
        }
    }

    public synchronized String getFileNo(String institutionNo) {
        String newFileNo = this.dbUtility.getSingleParamFunctionString("Bw_Lib_Seq.GenerateFileNumber", institutionNo);
        return TextUtil.fillLeftSide((String)newFileNo, (int)8, (char)'0');
    }

    public synchronized String getRcnSlipNo(String institutionNo) {
        String newSlipNo = this.dbUtility.getSingleParamFunctionStringReturnString("Bw_Lib_Seq.GenerateReconSlipNo", institutionNo);
        return newSlipNo;
    }

    public synchronized String getRcnSlipNo(String institutionNo, String postingDate) {
        String newSlipNo = this.dbUtility.getDoubleParamFunctionStringReturnString("Bw_Lib_Seq.GenerateReconSlipNo", institutionNo, postingDate);
        return newSlipNo;
    }

    public synchronized String getFileNo(String procedure, String institutionNo) {
        String newFileNo = this.dbUtility.getSingleParamFunctionString(procedure, institutionNo);
        return TextUtil.fillLeftSide((String)newFileNo, (int)8, (char)'0');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HashMap<String, String> getExtraCharges(String sqlText) {
        HashMap<String, String> extraCharges = new HashMap<String, String>();
        ResultSet rsExtra = this.dbUtility.executeQuery(sqlText);
        try {
            while (rsExtra.next()) {
                String indexField = rsExtra.getString("INDEX_FIELD");
                String visaCode = rsExtra.getString("VISA_CODE");
                String inetCode = rsExtra.getString("INET_CODE");
                if (visaCode == null) {
                    visaCode = inetCode;
                }
                if (visaCode == null) continue;
                extraCharges.put(visaCode, indexField);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(rsExtra);
        }
        return extraCharges;
    }

    public String getCountryRegion(String institutionNo, String Country2) {
        return systemCountryRegion.get(institutionNo + Country2);
    }

    public String getRegion(String regionIndex, String Language) {
        if (Language == null) {
            Language = "USA";
        }
        return regions.get(regionIndex + Language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadCountryCodes() {
        countryCodes2 = new HashMap();
        countryCodes3 = new HashMap();
        countrys = new HashMap();
        ResultSet rsCodes = this.dbUtility.executeQuery("Select * from BWT_COUNTRY");
        try {
            while (rsCodes.next()) {
                Country newCountry = new Country();
                String indexField = rsCodes.getString("INDEX_FIELD");
                String countryCode2 = rsCodes.getString("COUNTRY_CODE_2");
                String countryCode3 = rsCodes.getString("COUNTRY_CODE_3");
                newCountry.setIsoValue(indexField);
                newCountry.setCountryCodeOf2(countryCode2);
                newCountry.setCountryCodeOf3(countryCode3);
                newCountry.setName(rsCodes.getString("CLIENT_COUNTRY"));
                newCountry.setNationality(rsCodes.getString("NATIONALITY"));
                newCountry.setTelCode(rsCodes.getString("TEL_CODE"));
                if (countryCode2 != null) {
                    countryCodes2.put(countryCode2, indexField);
                }
                if (countryCode3 != null) {
                    countryCodes3.put(countryCode3, indexField);
                }
                countrys.put(indexField, newCountry);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(rsCodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadCountryStateCodes() {
        countryStateCodes = new HashMap();
        ResultSet rsCntryStates = this.dbUtility.executeQuery("Select INDEX_FIELD, COUNTRY_CODE, STATE_CODE from BWT_COUNTRY_STATE");
        try {
            while (rsCntryStates.next()) {
                String stateCode = rsCntryStates.getString("STATE_CODE");
                String countryCode = rsCntryStates.getString("COUNTRY_CODE");
                countryStateCodes.put(stateCode, countryCode);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(rsCntryStates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadSystemCountryRegion() {
        systemCountryRegion = new HashMap();
        ResultSet rsCntryRegion = this.dbUtility.executeQuery("Select REGION, COUNTRY, INSTITUTION_NUMBER from SYS_COUNTRY_REGION");
        try {
            while (rsCntryRegion.next()) {
                String region = rsCntryRegion.getString("REGION");
                String countryCode = rsCntryRegion.getString("COUNTRY");
                String instNum = rsCntryRegion.getString("INSTITUTION_NUMBER");
                systemCountryRegion.put(instNum + countryCode, region);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(rsCntryRegion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadRegions() {
        regions = new HashMap();
        ResultSet rsRegion = this.dbUtility.executeQuery("Select  distinct INDEX_FIELD, REGION, LANGUAGE from BWT_REGION");
        try {
            while (rsRegion.next()) {
                String indexField = rsRegion.getString("INDEX_FIELD");
                String lang = rsRegion.getString("LANGUAGE");
                String region = rsRegion.getString("REGION");
                regions.put(indexField + lang, region);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(rsRegion);
        }
    }

    public synchronized void loadCurrencies() {
        currencies = new HashMap();
        ResultSet rsCurrency = this.dbUtility.executeQuery("Select  distinct ISO_CODE, SWIFT_CODE, LOCAL_CODE, NAME, EXPONENT, CALC_BASE, SYMBOL, SORT_FIELD from BWT_CURRENCY Where LANGUAGE='USA'");
        try {
            while (rsCurrency.next()) {
                Currency newCurrency = new Currency();
                newCurrency.setISOCode(rsCurrency.getString("ISO_CODE"));
                newCurrency.setSwiftCode(rsCurrency.getString("SWIFT_CODE"));
                newCurrency.setLocalCode(rsCurrency.getString("LOCAL_CODE"));
                newCurrency.setName(rsCurrency.getString("NAME"));
                newCurrency.setExponent(rsCurrency.getInt("EXPONENT"));
                newCurrency.setCalcBase(rsCurrency.getInt("CALC_BASE"));
                newCurrency.setSymbol(rsCurrency.getString("SYMBOL"));
                newCurrency.setSortField(rsCurrency.getString("SORT_FIELD"));
                currencies.put(newCurrency.getISOCode(), newCurrency);
            }
        }
        catch (Exception ex) {
            this.handleDBError(ex);
        }
        finally {
            this.dbUtility.closeCursor(rsCurrency);
        }
    }

    public synchronized boolean checkInterchangeDetails(String InstitutionNo, String CardOrganization, String ClientRegion) throws CardConflictException {
        boolean result = false;
        boolean cardOrgError = false;
        if (InstitutionNo == null || CardOrganization == null || ClientRegion == null) {
            return false;
        }
        String key = InstitutionNo + CardOrganization + ClientRegion;
        if (interchangeDetails.containsKey(key)) {
            int recCount = Integer.parseInt(interchangeDetails.get(key));
            boolean bl = result = recCount > 0;
            if (result) {
                if (CardOrganization.equals("002")) {
                    if (this.checkInterchangeDetails(InstitutionNo, "001", ClientRegion)) {
                        cardOrgError = true;
                    }
                } else if (CardOrganization.equals("001") && this.checkInterchangeDetails(InstitutionNo, "002", ClientRegion)) {
                    cardOrgError = true;
                }
                if (cardOrgError) {
                    throw new CardConflictException(InstitutionNo, this.getRegion(ClientRegion, null));
                }
            }
        }
        return result;
    }

    public synchronized void loadExtraChargesCarRental() {
        extraChargesCarRental = this.getExtraCharges("Select INDEX_FIELD, VISA_CODE, INET_CODE from BWT_EXTRA_CHARGES_AUTO_RENTAL");
    }

    public synchronized void loadExtraChargesLodging() {
        extraChargesLodging = this.getExtraCharges("Select INDEX_FIELD, VISA_CODE, INET_CODE from BWT_EXTRA_CHARGES_LODGING");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContractDetailsExist(boolean useGroup, boolean getGroupClt, String contractType, String clientNumber, String effectiveDate, String institutionNumber, String groupNumber) {
        boolean result = false;
        ResultSet rsCntr = null;
        try {
            rsCntr = this.getContractDetails(useGroup, getGroupClt, contractType, clientNumber, effectiveDate, institutionNumber, groupNumber);
            result = this.dbUtility.isExist(rsCntr);
            boolean bl = this.dbUtility.isExist(rsCntr);
            this.dbUtility.closeCursor(rsCntr);
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.dbUtility.closeCursor(rsCntr);
        }
        return result;
    }

    public ResultSet getContractDetails(boolean useGroup, boolean getGroupClt, String contractType, String clientNumber, String effectiveDate, String institutionNumber, String groupNumber) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rsCntr = null;
        String sqlStatement = DynamicSQLStatements.getContractDetails(useGroup, getGroupClt);
        System.out.println(sqlStatement);
        stmt = this.dbConnection.prepareStatement(sqlStatement);
        stmt.setString(1, contractType);
        stmt.setString(2, clientNumber);
        stmt.setString(3, institutionNumber);
        stmt.setString(4, contractType);
        stmt.setString(5, clientNumber);
        stmt.setString(6, institutionNumber);
        stmt.setString(7, effectiveDate);
        if (useGroup) {
            stmt.setString(8, groupNumber);
            stmt.setString(9, groupNumber);
            if (getGroupClt) {
                stmt.setString(10, effectiveDate);
            }
        } else if (getGroupClt) {
            stmt.setString(8, effectiveDate);
        }
        rsCntr = stmt.executeQuery();
        return rsCntr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceContract getServiceContract(String institutionNumber, String contractID) {
        ServiceContract newContract;
        ResultSet rsSvrCntr;
        block4: {
            rsSvrCntr = null;
            newContract = null;
            try {
                rsSvrCntr = this.dbUtility.getDoubleParamSQL(institutionNumber, contractID, "Select * from  from CBR_SERVICE_CONTRACT Where INSTITUTION_NUMBER=? AND SERVICE_CONTRACT_ID=?");
                if (!rsSvrCntr.next()) break block4;
                newContract = new ServiceContract();
                newContract.setInstitutionNumber(institutionNumber);
                newContract.setServiceContractID(contractID);
                newContract.setContractType(rsSvrCntr.getString("CONTRACT_TYPE"));
                newContract.setNoteText(rsSvrCntr.getString("NOTE_TEXT"));
                newContract.setRecordDate(rsSvrCntr.getString("RECORD_DATE"));
                newContract.setReviewPeriod(rsSvrCntr.getString("REVIEW_PERIOD"));
            }
            catch (Exception ex) {
                try {
                    this.handleDBError(ex);
                }
                catch (Throwable throwable) {
                    this.dbUtility.closeCursor(rsSvrCntr);
                    throw throwable;
                }
                this.dbUtility.closeCursor(rsSvrCntr);
            }
        }
        this.dbUtility.closeCursor(rsSvrCntr);
        return newContract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientLink loadClientLink(boolean useGroup, boolean getGroupClt, String contractType, String clientNumber, String effectiveDate, String institutionNumber, String groupNumber) {
        ClientLink newClient;
        ResultSet rs;
        block4: {
            rs = null;
            newClient = null;
            try {
                rs = this.getContractDetails(useGroup, getGroupClt, contractType, clientNumber, effectiveDate, institutionNumber, groupNumber);
                if (!rs.next()) break block4;
                String contractID = rs.getString("CONTRACT_REFERENCE");
                newClient.setInstitutionNumber(rs.getString("INSTITUTION_NUMBER"));
                newClient.setBankReference(rs.getString("BANK_REFERENCE"));
                newClient.setClientNumber(rs.getString("CLIENT_NUMBER"));
                newClient.setClientBranch(rs.getString("CLIENT_BRANCH"));
                newClient.setClientLevel(rs.getString("CLIENT_LEVEL"));
                newClient.setClientTariff(rs.getString("CLIENT_TARIFF"));
                newClient.setChargeTierLevel(rs.getString("CHARGE_TIER_LEVEL"));
                newClient.setContractCategory(rs.getString("CONTRACT_CATEGORY"));
                newClient.setContractStatus(rs.getString("CONTRACT_STATUS"));
                newClient.setCostCenter(rs.getString("COST_CENTER"));
                newClient.setEffectiveDate(rs.getString("EFFECTIVE_DATE"));
                newClient.setExpiryDate(rs.getString("EXPIRY_DATE"));
                newClient.setGroupNumber(rs.getString("GROUP_NUMBER"));
                newClient.setInstitutionAccountOfficer(rs.getString("INSTITUTION_ACCT_OFFICER"));
                newClient.setProviderAccountOfficer(rs.getString("PROVIDER_ACCT_OFFICER"));
                newClient.setParentClientNumber(rs.getString("PARENT_CLIENT_NUMBER"));
                newClient.setPostingMethod(rs.getString("POSTING_METHOD"));
                newClient.setRecordDate(rs.getString("RECORD_DATE"));
                newClient.setSettlementMethod(rs.getString("SETTLEMENT_METHOD"));
                newClient.setServiceContract(this.getServiceContract(institutionNumber, contractID));
            }
            catch (Exception ex) {
                try {
                    this.handleDBError(ex);
                }
                catch (Throwable throwable) {
                    this.dbUtility.closeCursor(rs);
                    throw throwable;
                }
                this.dbUtility.closeCursor(rs);
            }
        }
        this.dbUtility.closeCursor(rs);
        return newClient;
    }
}

