/*
 * Decompiled with CFR 0.152.
 */
package org.smyld.bw.db;

import org.smyld.bw.data.structurs.MessageLog;
import org.smyld.bw.data.structurs.SystemJob;
import org.smyld.bw.db.BWDataBase;
import org.smyld.db.DBConnection;
import org.smyld.db.DBErrorHandler;
import org.smyld.text.TextUtil;
import org.smyld.util.SMYLDDate;
import org.smyld.util.Util;

public class MessageLogSaver
extends BWDataBase {
    private static final long serialVersionUID = 1L;

    public MessageLogSaver(DBErrorHandler e, DBConnection connection) {
        super(e, connection);
    }

    public MessageLogSaver(DBErrorHandler e) {
        super(e);
    }

    protected synchronized void setMessageAdditionalText(MessageLog newMessage, Exception exp) {
        this.setMessageAdditionalText(newMessage, Util.extractExceptionStackTrace((Exception)exp));
    }

    protected synchronized void setMessageAdditionalText(MessageLog newMessage, String expText) {
        if (expText != null && expText.length() > 2000) {
            expText = TextUtil.resize((String)expText, (int)2000);
        }
        newMessage.AdditionalText = expText;
    }

    public synchronized void addProgramException(SystemJob systemJob, Exception exp, String errorSource, String functionName) {
        try {
            this.addProgramException(systemJob, Util.extractExceptionStackTrace((Exception)exp), errorSource, functionName);
        }
        catch (Exception e) {
            System.out.println("Can not log messages into the system due to the below reason :");
            e.printStackTrace();
        }
    }

    public synchronized void addProgramException(SystemJob systemJob, String exceptionText, String errorSource, String functionName) {
        MessageLog newMessage = this.fillOneParamMessage(systemJob, "99999999", "900", errorSource, null, null, functionName);
        this.setMessageAdditionalText(newMessage, "Unknown exception ! please contact SMYLD and send this technical details ('" + exceptionText + "')");
        this.insertMessageLog(newMessage);
    }

    protected synchronized String getProcessFileName(SystemJob systemJob) {
        return systemJob.getParameterIn("p_filename");
    }

    protected synchronized String getProcessFilePath(SystemJob systemJob) {
        return systemJob.getParameterIn("p_filepath");
    }

    public synchronized void addOneParamMessage(String msgText, SystemJob systemJob, String msgCode, String msgType, String param1, String fileNo, String trnSlip, String functionName) {
        MessageLog newMessage = this.fillOneParamMessage(systemJob, msgCode, msgType, param1, fileNo, trnSlip, functionName);
        if (msgText != null) {
            this.setMessageAdditionalText(newMessage, msgText);
        }
        this.insertMessageLog(newMessage);
    }

    public synchronized void addTwoParamMessage(String msgText, SystemJob systemJob, String msgCode, String msgType, String param1, String param2, String fileNo, String trnSlip, String functionName) {
        MessageLog newMessage = this.fillTwoParamMessage(systemJob, msgCode, msgType, param1, param2, fileNo, trnSlip, functionName);
        if (msgText != null) {
            this.setMessageAdditionalText(newMessage, msgText);
        }
        this.insertMessageLog(newMessage);
    }

    public synchronized void addThreeParamMessage(String msgText, SystemJob systemJob, String msgCode, String msgType, String param1, String param2, String param3, String fileNo, String trnSlip, String functionName) {
        MessageLog newMessage = this.fillThreeParamMessage(systemJob, msgCode, msgType, param1, param2, param3, fileNo, trnSlip, functionName);
        if (msgText != null) {
            this.setMessageAdditionalText(newMessage, msgText);
        }
        this.insertMessageLog(newMessage);
    }

    public synchronized void addFourParamMessage(String msgText, SystemJob systemJob, String msgCode, String msgType, String param1, String param2, String param3, String param4, String fileNo, String trnSlip, String functionName) {
        MessageLog newMessage = this.fillFourParamMessage(systemJob, msgCode, msgType, param1, param2, param3, param4, fileNo, trnSlip, functionName);
        if (msgText != null) {
            this.setMessageAdditionalText(newMessage, msgText);
        }
        this.insertMessageLog(newMessage);
    }

    public synchronized void addFiveParamMessage(String msgText, SystemJob systemJob, String msgCode, String msgType, String param1, String param2, String param3, String param4, String param5, String fileNo, String trnSlip, String functionName) {
        MessageLog newMessage = this.fillFiveParamMessage(systemJob, msgCode, msgType, param1, param2, param3, param4, param5, fileNo, trnSlip, functionName);
        if (msgText != null) {
            this.setMessageAdditionalText(newMessage, msgText);
        }
        this.insertMessageLog(newMessage);
    }

    public synchronized MessageLog fillOneParamMessage(SystemJob systemJob, String msgCode, String msgType, String param1, String fileNo, String trnSlip, String functionName) {
        SMYLDDate currentDate = new SMYLDDate("yyyyMMdd");
        MessageLog newMessageLog = new MessageLog();
        if (systemJob != null) {
            newMessageLog.InstitutionNo = systemJob.getInstitutionNo();
            newMessageLog.ProcessNo = systemJob.getNo();
        }
        newMessageLog.FileNo = fileNo;
        newMessageLog.TrnSlip = trnSlip;
        newMessageLog.SystemDate = currentDate.toString();
        newMessageLog.SystemTime = currentDate.toString("HH:mm:ss");
        newMessageLog.ProcessMessageType = msgType;
        newMessageLog.Code = msgCode;
        newMessageLog.setParamValue(0, param1);
        newMessageLog.FunctionName = functionName;
        newMessageLog.ProcessMessageSource = "008";
        return newMessageLog;
    }

    public synchronized MessageLog fillTwoParamMessage(SystemJob systemJob, String msgCode, String msgType, String param1, String param2, String fileNo, String trnSlip, String functionName) {
        MessageLog newMessageLog = this.fillOneParamMessage(systemJob, msgCode, msgType, param1, fileNo, trnSlip, functionName);
        newMessageLog.setParamValue(1, param2);
        return newMessageLog;
    }

    public synchronized MessageLog fillThreeParamMessage(SystemJob systemJob, String msgCode, String msgType, String param1, String param2, String param3, String fileNo, String trnSlip, String functionName) {
        MessageLog newMessageLog = this.fillTwoParamMessage(systemJob, msgCode, msgType, param1, param2, fileNo, trnSlip, functionName);
        newMessageLog.setParamValue(2, param3);
        return newMessageLog;
    }

    public synchronized MessageLog fillFourParamMessage(SystemJob systemJob, String msgCode, String msgType, String param1, String param2, String param3, String param4, String fileNo, String trnSlip, String functionName) {
        MessageLog newMessageLog = this.fillThreeParamMessage(systemJob, msgCode, msgType, param1, param2, param3, fileNo, trnSlip, functionName);
        newMessageLog.setParamValue(3, param4);
        return newMessageLog;
    }

    public synchronized MessageLog fillFiveParamMessage(SystemJob systemJob, String msgCode, String msgType, String param1, String param2, String param3, String param4, String param5, String fileNo, String trnSlip, String functionName) {
        MessageLog newMessageLog = this.fillFourParamMessage(systemJob, msgCode, msgType, param1, param2, param3, param4, fileNo, trnSlip, functionName);
        newMessageLog.setParamValue(4, param5);
        return newMessageLog;
    }

    public synchronized MessageLog fillSixParamMessage(SystemJob systemJob, String msgCode, String msgType, String param1, String param2, String param3, String param4, String param5, String param6, String fileNo, String trnSlip, String functionName) {
        MessageLog newMessageLog = this.fillFiveParamMessage(systemJob, msgCode, msgType, param1, param2, param3, param4, param5, fileNo, trnSlip, functionName);
        newMessageLog.setParamValue(5, param6);
        return newMessageLog;
    }

    public synchronized MessageLog fillMultiParamMessage(SystemJob systemJob, String msgCode, String msgType, String[] params, String fileNo, String trnSlip, String functionName) {
        return null;
    }

    public synchronized boolean insertMessageLog(MessageLog newMessage) {
        String[] params = new String[27];
        params[0] = newMessage.ProcessNo;
        params[1] = newMessage.ProcessMessageType;
        params[2] = newMessage.ProcessMessageSource;
        params[3] = newMessage.Code;
        params[4] = newMessage.ExternalCode;
        if (newMessage.isFullMessageDescription()) {
            newMessage.constructFullMessageDescription();
            params[5] = newMessage.fullMessageDescription;
        } else {
            params[5] = newMessage.AdditionalText;
        }
        params[6] = newMessage.FunctionName;
        params[7] = newMessage.InstitutionNo;
        params[8] = newMessage.FileNo;
        params[9] = newMessage.TrnSlip;
        params[10] = newMessage.getParamValue(0);
        params[11] = newMessage.getParamValue(1);
        params[12] = newMessage.getParamValue(2);
        params[13] = newMessage.getParamValue(3);
        params[14] = newMessage.getParamValue(4);
        params[15] = newMessage.getParamValue(5);
        params[16] = newMessage.getParamValue(6);
        params[17] = newMessage.getParamValue(7);
        params[18] = newMessage.getParamValue(8);
        params[19] = newMessage.getParamValue(9);
        params[20] = newMessage.getParamValue(10);
        params[21] = newMessage.getParamValue(11);
        params[22] = newMessage.getParamValue(12);
        params[23] = newMessage.getParamValue(13);
        params[24] = newMessage.getParamValue(14);
        params[25] = newMessage.getParamValue(15);
        params[26] = " ";
        this.executeMultiParamProcedure("Bw_Lib_Messages.Insertprocessmessage", params);
        return false;
    }
}

